/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadUtils {
    private static Logger log = LoggerFactory.getLogger(MultiThreadUtils.class);
    private static ExecutorService instance;

    private MultiThreadUtils() {
    }

    public static synchronized ExecutorService newExecutorService() {
        int nThreads = Runtime.getRuntime().availableProcessors();
        return new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new LinkedTransferQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
    }

    public static void parallelTasks(final List<Runnable> tasks, ExecutorService executorService) {
        int tasksCount = tasks.size();
        final CountDownLatch latch = new CountDownLatch(tasksCount);
        int i = 0;
        while (i < tasksCount) {
            final int taskIdx = i++;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((Runnable)tasks.get(taskIdx)).run();
                    }
                    catch (Throwable e) {
                        log.info("Unchecked exception thrown by task", e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

