/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.layers.feedforward.rbm.RBM;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.updater.graph.ComputationGraphUpdater;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.preprocessor.DataNormalization;
import org.nd4j.linalg.dataset.api.preprocessor.Normalizer;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializer;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.heartbeat.reports.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSerializer {
    private static final Logger log = LoggerFactory.getLogger(ModelSerializer.class);
    public static final String OLD_UPDATER_BIN = "updater.bin";
    public static final String UPDATER_BIN = "updaterState.bin";
    public static final String NORMALIZER_BIN = "normalizer.bin";

    private ModelSerializer() {
    }

    public static void writeModel(@NonNull Model model, @NonNull File file, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            ModelSerializer.writeModel(model, stream, saveUpdater);
        }
    }

    public static void writeModel(@NonNull Model model, @NonNull String path, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(path));){
            ModelSerializer.writeModel(model, stream, saveUpdater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModel(@NonNull Model model, @NonNull OutputStream stream, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        ZipOutputStream zipfile = new ZipOutputStream((OutputStream)new CloseShieldOutputStream(stream));
        String json = "";
        if (model instanceof MultiLayerNetwork) {
            json = ((MultiLayerNetwork)model).getLayerWiseConfigurations().toJson();
        } else if (model instanceof ComputationGraph) {
            json = ((ComputationGraph)model).getConfiguration().toJson();
        }
        ZipEntry config = new ZipEntry("configuration.json");
        zipfile.putNextEntry(config);
        zipfile.write(json.getBytes());
        ZipEntry coefficients = new ZipEntry("coefficients.bin");
        zipfile.putNextEntry(coefficients);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zipfile));
        try {
            Nd4j.write((INDArray)model.params(), (DataOutputStream)dos);
        }
        finally {
            dos.flush();
            if (!saveUpdater) {
                dos.close();
            }
        }
        if (saveUpdater) {
            INDArray updaterState = null;
            if (model instanceof MultiLayerNetwork) {
                updaterState = ((MultiLayerNetwork)model).getUpdater().getStateViewArray();
            } else if (model instanceof ComputationGraph) {
                updaterState = ((ComputationGraph)model).getUpdater().getStateViewArray();
            }
            if (updaterState != null && updaterState.length() > 0) {
                ZipEntry updater = new ZipEntry(UPDATER_BIN);
                zipfile.putNextEntry(updater);
                try {
                    Nd4j.write((INDArray)updaterState, (DataOutputStream)dos);
                }
                finally {
                    dos.flush();
                    dos.close();
                }
            }
        }
        zipfile.flush();
        zipfile.close();
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return ModelSerializer.restoreMultiLayerNetwork(file, true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull File file, boolean loadUpdater) throws IOException {
        ZipEntry prep;
        ObjectInputStream ois;
        InputStream stream;
        ZipEntry coefficients;
        if (file == null) {
            throw new NullPointerException("file");
        }
        ZipFile zipFile = new ZipFile(file);
        boolean gotConfig = false;
        boolean gotCoefficients = false;
        boolean gotOldUpdater = false;
        boolean gotUpdaterState = false;
        boolean gotPreProcessor = false;
        String json = "";
        INDArray params = null;
        Updater updater = null;
        INDArray updaterState = null;
        DataSetPreProcessor preProcessor = null;
        ZipEntry config = zipFile.getEntry("configuration.json");
        if (config != null) {
            InputStream stream2 = zipFile.getInputStream(config);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream2));
            String line = "";
            StringBuilder js = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                js.append(line).append("\n");
            }
            json = js.toString();
            reader.close();
            stream2.close();
            gotConfig = true;
        }
        if ((coefficients = zipFile.getEntry("coefficients.bin")) != null) {
            InputStream stream3 = zipFile.getInputStream(coefficients);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(stream3));
            params = Nd4j.read((DataInputStream)dis);
            dis.close();
            gotCoefficients = true;
        }
        if (loadUpdater) {
            ZipEntry updaterStateEntry;
            ZipEntry oldUpdaters = zipFile.getEntry(OLD_UPDATER_BIN);
            if (oldUpdaters != null) {
                stream = zipFile.getInputStream(oldUpdaters);
                ois = new ObjectInputStream(stream);
                try {
                    updater = (Updater)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                gotOldUpdater = true;
            }
            if ((updaterStateEntry = zipFile.getEntry(UPDATER_BIN)) != null) {
                InputStream stream4 = zipFile.getInputStream(updaterStateEntry);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(stream4));
                updaterState = Nd4j.read((DataInputStream)dis);
                dis.close();
                gotUpdaterState = true;
            }
        }
        if ((prep = zipFile.getEntry("preprocessor.bin")) != null) {
            stream = zipFile.getInputStream(prep);
            ois = new ObjectInputStream(stream);
            try {
                preProcessor = (DataSetPreProcessor)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            gotPreProcessor = true;
        }
        zipFile.close();
        if (gotConfig && gotCoefficients) {
            MultiLayerConfiguration confFromJson = MultiLayerConfiguration.fromJson(json);
            MultiLayerNetwork network = new MultiLayerNetwork(confFromJson);
            network.init(params, false);
            if (gotUpdaterState && updaterState != null) {
                network.getUpdater().setStateViewArray(network, updaterState, false);
            } else if (gotOldUpdater && updater != null) {
                network.setUpdater(updater);
            }
            return network;
        }
        throw new IllegalStateException("Model wasnt found within file: gotConfig: [" + gotConfig + "], gotCoefficients: [" + gotCoefficients + "], gotUpdater: [" + gotUpdaterState + "]");
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is");
        }
        File tmpFile = File.createTempFile("restore", "multiLayer");
        tmpFile.deleteOnExit();
        FileUtils.copyInputStreamToFile((InputStream)is, (File)tmpFile);
        return ModelSerializer.restoreMultiLayerNetwork(tmpFile, loadUpdater);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("is");
        }
        return ModelSerializer.restoreMultiLayerNetwork(is, true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return ModelSerializer.restoreMultiLayerNetwork(new File(path), true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull String path, boolean loadUpdater) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return ModelSerializer.restoreMultiLayerNetwork(new File(path), loadUpdater);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return ModelSerializer.restoreComputationGraph(new File(path), true);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull String path, boolean loadUpdater) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return ModelSerializer.restoreComputationGraph(new File(path), loadUpdater);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is");
        }
        File tmpFile = File.createTempFile("restore", "compGraph");
        tmpFile.deleteOnExit();
        FileUtils.copyInputStreamToFile((InputStream)is, (File)tmpFile);
        return ModelSerializer.restoreComputationGraph(tmpFile, loadUpdater);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("is");
        }
        return ModelSerializer.restoreComputationGraph(is, true);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return ModelSerializer.restoreComputationGraph(file, true);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull File file, boolean loadUpdater) throws IOException {
        ZipEntry prep;
        ObjectInputStream ois;
        InputStream stream;
        ZipEntry coefficients;
        if (file == null) {
            throw new NullPointerException("file");
        }
        ZipFile zipFile = new ZipFile(file);
        boolean gotConfig = false;
        boolean gotCoefficients = false;
        boolean gotOldUpdater = false;
        boolean gotUpdaterState = false;
        boolean gotPreProcessor = false;
        String json = "";
        INDArray params = null;
        ComputationGraphUpdater updater = null;
        INDArray updaterState = null;
        DataSetPreProcessor preProcessor = null;
        ZipEntry config = zipFile.getEntry("configuration.json");
        if (config != null) {
            InputStream stream2 = zipFile.getInputStream(config);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream2));
            String line = "";
            StringBuilder js = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                js.append(line).append("\n");
            }
            json = js.toString();
            reader.close();
            stream2.close();
            gotConfig = true;
        }
        if ((coefficients = zipFile.getEntry("coefficients.bin")) != null) {
            InputStream stream3 = zipFile.getInputStream(coefficients);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(stream3));
            params = Nd4j.read((DataInputStream)dis);
            dis.close();
            gotCoefficients = true;
        }
        if (loadUpdater) {
            ZipEntry updaterStateEntry;
            ZipEntry oldUpdaters = zipFile.getEntry(OLD_UPDATER_BIN);
            if (oldUpdaters != null) {
                stream = zipFile.getInputStream(oldUpdaters);
                ois = new ObjectInputStream(stream);
                try {
                    updater = (ComputationGraphUpdater)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                gotOldUpdater = true;
            }
            if ((updaterStateEntry = zipFile.getEntry(UPDATER_BIN)) != null) {
                InputStream stream4 = zipFile.getInputStream(updaterStateEntry);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(stream4));
                updaterState = Nd4j.read((DataInputStream)dis);
                dis.close();
                gotUpdaterState = true;
            }
        }
        if ((prep = zipFile.getEntry("preprocessor.bin")) != null) {
            stream = zipFile.getInputStream(prep);
            ois = new ObjectInputStream(stream);
            try {
                preProcessor = (DataSetPreProcessor)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            gotPreProcessor = true;
        }
        zipFile.close();
        if (gotConfig && gotCoefficients) {
            ComputationGraphConfiguration confFromJson = ComputationGraphConfiguration.fromJson(json);
            ComputationGraph cg = new ComputationGraph(confFromJson);
            cg.init(params, false);
            if (gotUpdaterState && updaterState != null) {
                cg.getUpdater().setStateViewArray(updaterState);
            } else if (gotOldUpdater && updater != null) {
                cg.setUpdater(updater);
            }
            return cg;
        }
        throw new IllegalStateException("Model wasnt found within file: gotConfig: [" + gotConfig + "], gotCoefficients: [" + gotCoefficients + "], gotUpdater: [" + gotUpdaterState + "]");
    }

    public static Task taskByModel(Model model) {
        Task task = new Task();
        try {
            block21: {
                task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                if (model instanceof ComputationGraph) {
                    task.setNetworkType(Task.NetworkType.ComputationalGraph);
                    ComputationGraph network = (ComputationGraph)model;
                    try {
                        if (network.getLayers() != null && network.getLayers().length > 0) {
                            for (Layer layer : network.getLayers()) {
                                if (layer instanceof org.deeplearning4j.nn.conf.layers.RBM || layer instanceof RBM) {
                                    task.setArchitectureType(Task.ArchitectureType.RBM);
                                } else if (layer.type().equals((Object)Layer.Type.CONVOLUTIONAL)) {
                                    task.setArchitectureType(Task.ArchitectureType.CONVOLUTION);
                                } else {
                                    if (!layer.type().equals((Object)Layer.Type.RECURRENT) && !layer.type().equals((Object)Layer.Type.RECURSIVE)) continue;
                                    task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                                }
                                break block21;
                            }
                            break block21;
                        }
                        task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
                    }
                    catch (Exception exception) {}
                } else if (model instanceof MultiLayerNetwork) {
                    task.setNetworkType(Task.NetworkType.MultilayerNetwork);
                    MultiLayerNetwork network = (MultiLayerNetwork)model;
                    try {
                        if (network.getLayers() != null && network.getLayers().length > 0) {
                            for (Layer layer : network.getLayers()) {
                                if (layer instanceof org.deeplearning4j.nn.conf.layers.RBM || layer instanceof RBM) {
                                    task.setArchitectureType(Task.ArchitectureType.RBM);
                                } else if (layer.type().equals((Object)Layer.Type.CONVOLUTIONAL)) {
                                    task.setArchitectureType(Task.ArchitectureType.CONVOLUTION);
                                } else {
                                    if (!layer.type().equals((Object)Layer.Type.RECURRENT) && !layer.type().equals((Object)Layer.Type.RECURSIVE)) continue;
                                    task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                                }
                                break block21;
                            }
                            break block21;
                        }
                        task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return task;
        }
        catch (Exception e) {
            task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
            task.setNetworkType(Task.NetworkType.DenseNetwork);
            return task;
        }
    }

    public static void addNormalizerToModel(File f, Normalizer<?> normalizer) {
        try {
            File tempFile = File.createTempFile("tempcopy", "temp");
            tempFile.deleteOnExit();
            FileUtils.copyFile((File)f, (File)tempFile);
            try (ZipFile zipFile = new ZipFile(tempFile);
                 ZipOutputStream writeFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().equalsIgnoreCase(NORMALIZER_BIN)) continue;
                    log.debug("Copying: {}", (Object)entry.getName());
                    InputStream is = zipFile.getInputStream(entry);
                    ZipEntry wEntry = new ZipEntry(entry.getName());
                    writeFile.putNextEntry(wEntry);
                    IOUtils.copy((InputStream)is, (OutputStream)writeFile);
                }
                ZipEntry nEntry = new ZipEntry(NORMALIZER_BIN);
                writeFile.putNextEntry(nEntry);
                NormalizerSerializer.getDefault().write(normalizer, (OutputStream)writeFile);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Normalizer> T restoreNormalizerFromFile(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry norm = zipFile.getEntry(NORMALIZER_BIN);
            if (norm == null) {
                T t = null;
                return t;
            }
            Normalizer normalizer = NormalizerSerializer.getDefault().restore(zipFile.getInputStream(norm));
            return (T)normalizer;
        }
        catch (Exception e) {
            log.warn("Error while restoring normalizer, trying to restore assuming deprecated format...");
            DataNormalization restoredDeprecated = ModelSerializer.restoreNormalizerFromFileDeprecated(file);
            log.warn("Recovered using deprecated method. Will now re-save the normalizer to fix this issue.");
            ModelSerializer.addNormalizerToModel(file, restoredDeprecated);
            return (T)restoredDeprecated;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static DataNormalization restoreNormalizerFromFileDeprecated(File file) {
        try {
            Throwable throwable = null;
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry norm = zipFile.getEntry(NORMALIZER_BIN);
                if (norm == null) {
                    DataNormalization dataNormalization = null;
                    return dataNormalization;
                }
                InputStream stream = zipFile.getInputStream(norm);
                ObjectInputStream ois = new ObjectInputStream(stream);
                try {
                    DataNormalization normalizer;
                    DataNormalization dataNormalization = normalizer = (DataNormalization)ois.readObject();
                    return dataNormalization;
                }
                catch (ClassNotFoundException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

