/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingLayer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Subsampling1DLayer
extends SubsamplingLayer {
    public Subsampling1DLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Subsampling1DLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        if (epsilon.rank() != 3) {
            throw new DL4JInvalidInputException("Got rank " + epsilon.rank() + " array as epsilon for Subsampling1DLayer backprop with shape " + Arrays.toString(epsilon.shape()) + ". Expected rank 3 array with shape [minibatchSize, features, length].");
        }
        INDArray origInput = this.input;
        this.input = this.input.reshape(new int[]{this.input.size(0), this.input.size(1), this.input.size(2), 1});
        epsilon = epsilon.reshape(new int[]{epsilon.size(0), epsilon.size(1), epsilon.size(2), 1});
        Pair<Gradient, INDArray> gradientEpsNext = super.backpropGradient(epsilon);
        INDArray epsNext = gradientEpsNext.getSecond();
        this.input = origInput;
        epsNext = epsNext.reshape(new int[]{epsNext.size(0), epsNext.size(1), epsNext.size(2)});
        return new Pair<Gradient, INDArray>(gradientEpsNext.getFirst(), epsNext);
    }

    @Override
    public INDArray activate(boolean training) {
        if (this.input.rank() != 3) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Subsampling1DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 3 array with shape [minibatchSize, features, length].");
        }
        INDArray origInput = this.input;
        this.input = this.input.reshape(new int[]{this.input.size(0), this.input.size(1), this.input.size(2), 1});
        INDArray acts = super.activate(training);
        this.input = origInput;
        acts = acts.reshape(new int[]{acts.size(0), acts.size(1), acts.size(2)});
        return acts;
    }
}

