/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.params.PretrainParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class RBM
extends BasePretrainNetwork {
    protected HiddenUnit hiddenUnit;
    protected VisibleUnit visibleUnit;
    protected int k;
    protected double sparsity;

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.feedforward.rbm.RBM ret = new org.deeplearning4j.nn.layers.feedforward.rbm.RBM(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return PretrainParamInitializer.getInstance();
    }

    private RBM(Builder builder) {
        super(builder);
        this.hiddenUnit = builder.hiddenUnit;
        this.visibleUnit = builder.visibleUnit;
        this.k = builder.k;
        this.sparsity = builder.sparsity;
    }

    public HiddenUnit getHiddenUnit() {
        return this.hiddenUnit;
    }

    public VisibleUnit getVisibleUnit() {
        return this.visibleUnit;
    }

    public int getK() {
        return this.k;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public void setHiddenUnit(HiddenUnit hiddenUnit) {
        this.hiddenUnit = hiddenUnit;
    }

    public void setVisibleUnit(VisibleUnit visibleUnit) {
        this.visibleUnit = visibleUnit;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setSparsity(double sparsity) {
        this.sparsity = sparsity;
    }

    public RBM() {
    }

    @Override
    public String toString() {
        return "RBM(super=" + super.toString() + ", hiddenUnit=" + (Object)((Object)this.getHiddenUnit()) + ", visibleUnit=" + (Object)((Object)this.getVisibleUnit()) + ", k=" + this.getK() + ", sparsity=" + this.getSparsity() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RBM)) {
            return false;
        }
        RBM other = (RBM)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HiddenUnit this$hiddenUnit = this.getHiddenUnit();
        HiddenUnit other$hiddenUnit = other.getHiddenUnit();
        if (this$hiddenUnit == null ? other$hiddenUnit != null : !((Object)((Object)this$hiddenUnit)).equals((Object)other$hiddenUnit)) {
            return false;
        }
        VisibleUnit this$visibleUnit = this.getVisibleUnit();
        VisibleUnit other$visibleUnit = other.getVisibleUnit();
        if (this$visibleUnit == null ? other$visibleUnit != null : !((Object)((Object)this$visibleUnit)).equals((Object)other$visibleUnit)) {
            return false;
        }
        if (this.getK() != other.getK()) {
            return false;
        }
        return Double.compare(this.getSparsity(), other.getSparsity()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RBM;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        HiddenUnit $hiddenUnit = this.getHiddenUnit();
        result = result * 59 + ($hiddenUnit == null ? 43 : ((Object)((Object)$hiddenUnit)).hashCode());
        VisibleUnit $visibleUnit = this.getVisibleUnit();
        result = result * 59 + ($visibleUnit == null ? 43 : ((Object)((Object)$visibleUnit)).hashCode());
        result = result * 59 + this.getK();
        long $sparsity = Double.doubleToLongBits(this.getSparsity());
        result = result * 59 + (int)($sparsity >>> 32 ^ $sparsity);
        return result;
    }

    public static class Builder
    extends BasePretrainNetwork.Builder<Builder> {
        private HiddenUnit hiddenUnit = HiddenUnit.BINARY;
        private VisibleUnit visibleUnit = VisibleUnit.BINARY;
        private int k = 1;
        private double sparsity = 0.0;

        public Builder(HiddenUnit hiddenUnit, VisibleUnit visibleUnit) {
            this.hiddenUnit = hiddenUnit;
            this.visibleUnit = visibleUnit;
        }

        public Builder() {
        }

        @Override
        public RBM build() {
            return new RBM(this);
        }

        public Builder k(int k) {
            this.k = k;
            return this;
        }

        public Builder hiddenUnit(HiddenUnit hiddenUnit) {
            this.hiddenUnit = hiddenUnit;
            return this;
        }

        public Builder visibleUnit(VisibleUnit visibleUnit) {
            this.visibleUnit = visibleUnit;
            return this;
        }

        public Builder sparsity(double sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        @ConstructorProperties(value={"hiddenUnit", "visibleUnit", "k", "sparsity"})
        public Builder(HiddenUnit hiddenUnit, VisibleUnit visibleUnit, int k, double sparsity) {
            this.hiddenUnit = hiddenUnit;
            this.visibleUnit = visibleUnit;
            this.k = k;
            this.sparsity = sparsity;
        }
    }

    public static enum HiddenUnit {
        RECTIFIED,
        BINARY,
        GAUSSIAN,
        SOFTMAX,
        IDENTITY;

    }

    public static enum VisibleUnit {
        BINARY,
        GAUSSIAN,
        SOFTMAX,
        LINEAR,
        IDENTITY;

    }
}

