/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;

public class BestScoreEpochTerminationCondition
implements EpochTerminationCondition {
    private final double bestExpectedScore;
    private boolean lesserBetter = true;

    public BestScoreEpochTerminationCondition(double bestExpectedScore) {
        this.bestExpectedScore = bestExpectedScore;
    }

    public BestScoreEpochTerminationCondition(double bestExpectedScore, boolean lesserBetter) {
        this(bestExpectedScore);
        this.lesserBetter = lesserBetter;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean terminate(int epochNum, double score) {
        if (this.lesserBetter) {
            return score < this.bestExpectedScore;
        }
        return this.bestExpectedScore < score;
    }

    public String toString() {
        return "BestScoreEpochTerminationCondition(" + this.bestExpectedScore + ")";
    }
}

