/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.local;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.LocallyConnected1D;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasLocallyConnected1D
extends KerasConvolution {
    private static final Logger log = LoggerFactory.getLogger(KerasLocallyConnected1D.class);

    public KerasLocallyConnected1D(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasLocallyConnected1D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasLocallyConnected1D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        this.numTrainableParams = this.hasBias ? 2 : 1;
        int[] dilationRate = KerasConvolutionUtils.getDilationRate(layerConfig, 1, this.conf, false);
        IWeightInit init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_W_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LocallyConnected1D.Builder builder = ((LocallyConnected1D.Builder)((LocallyConnected1D.Builder)((LocallyConnected1D.Builder)((LocallyConnected1D.Builder)((LocallyConnected1D.Builder)new LocallyConnected1D.Builder().name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf)).dropOut(this.dropout)).activation(KerasActivationUtils.getActivationFromConfig(layerConfig, this.conf)).weightInit(this.conf.getKERAS_PARAM_NAME_W(), init)).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf)).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 1, this.conf, this.kerasMajorVersion)[0]).hasBias(this.hasBias).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 1, this.conf)[0]);
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 1, this.conf, this.kerasMajorVersion);
        if (padding != null) {
            builder.padding(padding[0]);
        }
        if (dilationRate != null) {
            builder.dilation(dilationRate[0]);
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (weightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{weightConstraint});
        }
        this.layer = builder.build();
    }

    public LocallyConnected1D getLocallyConnected1DLayer() {
        return (LocallyConnected1D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Convolution layer accepts only one input (received " + inputType.length + ")");
        }
        InputType.InputTypeRecurrent rnnType = (InputType.InputTypeRecurrent)inputType[0];
        ((LocallyConnected1D)this.layer).setInputSize((int)rnnType.getTimeSeriesLength());
        ((LocallyConnected1D)this.layer).setNIn(rnnType.getSize());
        ((LocallyConnected1D)this.layer).computeOutputSize();
        InputPreProcessor preprocessor = this.getInputPreprocessor(inputType[0]);
        if (preprocessor != null) {
            return this.getLocallyConnected1DLayer().getOutputType(-1, preprocessor.getOutputType(inputType[0]));
        }
        return this.getLocallyConnected1DLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (!weights.containsKey(this.conf.getKERAS_PARAM_NAME_W())) {
            throw new InvalidKerasConfigurationException("Parameter " + this.conf.getKERAS_PARAM_NAME_W() + " does not exist in weights");
        }
        INDArray kerasParamValue = weights.get(this.conf.getKERAS_PARAM_NAME_W());
        this.weights.put("W", kerasParamValue);
        if (this.hasBias) {
            if (weights.containsKey(this.conf.getKERAS_PARAM_NAME_B())) {
                this.weights.put("b", weights.get(this.conf.getKERAS_PARAM_NAME_B()));
            } else {
                throw new InvalidKerasConfigurationException("Parameter " + this.conf.getKERAS_PARAM_NAME_B() + " does not exist in weights");
            }
        }
        KerasLayerUtils.removeDefaultWeights(weights, this.conf);
    }

    @Override
    public String toString() {
        return "KerasLocallyConnected1D()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasLocallyConnected1D)) {
            return false;
        }
        KerasLocallyConnected1D other = (KerasLocallyConnected1D)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KerasLocallyConnected1D;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

