/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Upsampling1D;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;

public class KerasUpsampling1D
extends KerasLayer {
    public KerasUpsampling1D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasUpsampling1D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        int[] size = KerasConvolutionUtils.getUpsamplingSizeFromConfig(layerConfig, 1, this.conf);
        Upsampling1D.Builder builder = ((Upsampling1D.Builder)((Upsampling1D.Builder)new Upsampling1D.Builder().name(this.layerName)).dropOut(this.dropout)).size(size[0]);
        this.layer = builder.build();
        this.vertex = null;
    }

    public Upsampling1D getUpsampling1DLayer() {
        return (Upsampling1D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Upsampling 1D layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getUpsampling1DLayer().getOutputType(-1, inputType[0]);
    }
}

