/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.Map;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.dropout.SpatialDropout;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;

public class KerasSpatialDropout
extends KerasLayer {
    public KerasSpatialDropout(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasSpatialDropout(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasSpatialDropout(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (!innerConfig.containsKey(this.conf.getLAYER_FIELD_RATE())) {
            throw new InvalidKerasConfigurationException("Keras configuration does not contain parameter" + this.conf.getLAYER_FIELD_RATE() + "needed for spatial dropout");
        }
        double rate = (Double)innerConfig.get(this.conf.getLAYER_FIELD_RATE());
        double retainRate = 1.0 - rate;
        this.layer = ((DropoutLayer.Builder)((DropoutLayer.Builder)new DropoutLayer.Builder().name(this.layerName)).dropOut((IDropout)new SpatialDropout(retainRate))).build();
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras SpatialDropout layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getSpatialDropoutLayer().getOutputType(-1, inputType[0]);
    }

    public DropoutLayer getSpatialDropoutLayer() {
        return (DropoutLayer)this.layer;
    }
}

