/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;

public class KerasSpaceToDepth
extends KerasLayer {
    public KerasSpaceToDepth(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasSpaceToDepth(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        SpaceToDepthLayer.Builder builder = new SpaceToDepthLayer.Builder().blocks(2).dataFormat(SpaceToDepthLayer.DataFormat.NHWC).name(this.layerName);
        this.layer = builder.build();
        this.vertex = null;
    }

    public SpaceToDepthLayer getSpaceToDepthLayer() {
        return (SpaceToDepthLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Space to Depth layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getSpaceToDepthLayer().getOutputType(-1, inputType[0]);
    }
}

