/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.convolutional.Cropping2D;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasCropping2D
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasCropping2D.class);

    public KerasCropping2D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasCropping2D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        String croppingField = this.conf.getLAYER_FIELD_CROPPING();
        int[] cropping = KerasConvolutionUtils.getPaddingFromConfig(layerConfig, this.conf, croppingField, 2);
        Cropping2D.Builder builder = (Cropping2D.Builder)((Cropping2D.Builder)new Cropping2D.Builder(cropping).dataFormat(this.dimOrder == KerasLayer.DimOrder.TENSORFLOW ? CNN2DFormat.NHWC : CNN2DFormat.NCHW).name(this.layerName)).dropOut(this.dropout);
        this.layer = builder.build();
        this.vertex = null;
    }

    public Cropping2D getCropping2DLayer() {
        return (Cropping2D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Cropping layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getCropping2DLayer().getOutputType(-1, inputType[0]);
    }

    public String toString() {
        return "KerasCropping2D()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasCropping2D)) {
            return false;
        }
        KerasCropping2D other = (KerasCropping2D)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasCropping2D;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

