/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasConvolution2D
extends KerasConvolution {
    private static final Logger log = LoggerFactory.getLogger(KerasConvolution2D.class);

    public KerasConvolution2D(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasConvolution2D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasConvolution2D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        this.numTrainableParams = this.hasBias ? 2 : 1;
        int[] dilationRate = KerasConvolutionUtils.getDilationRate(layerConfig, 2, this.conf, false);
        IWeightInit init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_W_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        ConvolutionLayer.Builder builder = ((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf))).dropOut(this.dropout)).activation(KerasActivationUtils.getIActivationFromConfig(layerConfig, this.conf))).weightInit(init)).dataFormat(this.dimOrder == KerasLayer.DimOrder.TENSORFLOW ? CNN2DFormat.NHWC : CNN2DFormat.NCHW).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf))).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 2, this.conf, this.kerasMajorVersion)).hasBias(this.hasBias)).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 2, this.conf));
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 2, this.conf, this.kerasMajorVersion);
        if (this.hasBias) {
            builder.biasInit(0.0);
        }
        if (padding != null) {
            builder.padding(padding);
        }
        if (dilationRate != null) {
            builder.dilation(dilationRate);
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (weightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{weightConstraint});
        }
        this.layer = builder.build();
        ConvolutionLayer convolutionLayer = (ConvolutionLayer)this.layer;
        convolutionLayer.setDefaultValueOverriden(true);
    }

    public ConvolutionLayer getConvolution2DLayer() {
        return (ConvolutionLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Convolution layer accepts only one input (received " + inputType.length + ")");
        }
        InputPreProcessor preprocessor = this.getInputPreprocessor(inputType[0]);
        if (preprocessor != null) {
            return this.getConvolution2DLayer().getOutputType(-1, preprocessor.getOutputType(inputType[0]));
        }
        return this.getConvolution2DLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public String toString() {
        return "KerasConvolution2D()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasConvolution2D)) {
            return false;
        }
        KerasConvolution2D other = (KerasConvolution2D)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KerasConvolution2D;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

