/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.modelimport.keras.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasDropout
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasDropout.class);

    public KerasDropout(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasDropout(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.layer = ((DropoutLayer.Builder)((DropoutLayer.Builder)new DropoutLayer.Builder().name(this.layerName)).dropOut(this.dropout)).build();
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Dropout layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getDropoutLayer().getOutputType(-1, inputType[0]);
    }

    public DropoutLayer getDropoutLayer() {
        return (DropoutLayer)this.layer;
    }
}

