/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.mnist;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.deeplearning4j.datasets.mnist.MnistImageFile;
import org.deeplearning4j.datasets.mnist.MnistLabelFile;

public class MnistManager {
    MnistImageFile images;
    private MnistLabelFile labels;
    private byte[][] imagesArr;
    private int[] labelsArr;
    private static final int HEADER_SIZE = 8;

    public static void writeImageToPpm(int[][] image, String ppmFileName) throws IOException {
        try (BufferedWriter ppmOut = new BufferedWriter(new FileWriter(ppmFileName));){
            int rows = image.length;
            int cols = image[0].length;
            ppmOut.write("P3\n");
            ppmOut.write("" + rows + " " + cols + " 255\n");
            for (int i = 0; i < rows; ++i) {
                StringBuilder s = new StringBuilder();
                for (int j = 0; j < cols; ++j) {
                    s.append(image[i][j] + " " + image[i][j] + " " + image[i][j] + "  ");
                }
                ppmOut.write(s.toString());
            }
        }
    }

    public MnistManager(String imagesFile, String labelsFile, boolean train) throws IOException {
        this(imagesFile, labelsFile, train ? 60000 : 10000);
    }

    public MnistManager(String imagesFile, String labelsFile, int numExamples) throws IOException {
        if (imagesFile != null) {
            this.images = new MnistImageFile(imagesFile, "r");
            this.imagesArr = this.images.readImagesUnsafe(numExamples);
        }
        if (labelsFile != null) {
            this.labels = new MnistLabelFile(labelsFile, "r");
            this.labelsArr = this.labels.readLabels(numExamples);
        }
    }

    public MnistManager(String imagesFile, String labelsFile) throws IOException {
        this(imagesFile, labelsFile, true);
    }

    public int[][] readImage() throws IOException {
        if (this.images == null) {
            throw new IllegalStateException("Images file not initialized.");
        }
        return this.images.readImage();
    }

    public byte[] readImageUnsafe(int i) {
        return this.imagesArr[i];
    }

    public void setCurrent(int index) {
        this.images.setCurrentIndex(index);
        this.labels.setCurrentIndex(index);
    }

    public int readLabel() throws IOException {
        if (this.labels == null) {
            throw new IllegalStateException("labels file not initialized.");
        }
        return this.labels.readLabel();
    }

    public int readLabel(int i) {
        return this.labelsArr[i];
    }

    public MnistImageFile getImages() {
        return this.images;
    }

    public MnistLabelFile getLabels() {
        return this.labels;
    }

    public void close() {
        if (this.images != null) {
            try {
                this.images.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.images = null;
        }
        if (this.labels != null) {
            try {
                this.labels.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.labels = null;
        }
    }
}

