/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.deeplearning4j.datasets.base.EmnistFetcher;
import org.deeplearning4j.datasets.fetchers.MnistDataFetcher;
import org.deeplearning4j.datasets.iterator.impl.EmnistDataSetIterator;
import org.deeplearning4j.datasets.mnist.MnistManager;
import org.eclipse.deeplearning4j.resources.utils.EMnistSet;
import org.nd4j.linalg.dataset.api.iterator.fetcher.DataSetFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmnistDataFetcher
extends MnistDataFetcher
implements DataSetFetcher {
    private static final Logger log = LoggerFactory.getLogger(EmnistDataFetcher.class);
    protected EmnistFetcher fetcher;

    public EmnistDataFetcher(EMnistSet dataSet, boolean binarize, boolean train, boolean shuffle, long rngSeed, File topLevelDir) throws IOException {
        this.fetcher = new EmnistFetcher(dataSet, topLevelDir);
        if (!this.emnistExists(this.fetcher)) {
            this.fetcher.downloadAndUntar();
        }
        String EMNIST_ROOT = topLevelDir.getAbsolutePath();
        if (train) {
            this.images = this.fetcher.getEmnistDataTrain().localPath().getAbsolutePath();
            this.labels = this.fetcher.getEmnistLabelsTrain().localPath().getAbsolutePath();
            this.totalExamples = EmnistDataSetIterator.numExamplesTrain(dataSet);
        } else {
            this.images = this.fetcher.getEmnistDataTest().localPath().getAbsolutePath();
            this.labels = this.fetcher.getEmnistLabelsTest().localPath().getAbsolutePath();
            this.totalExamples = EmnistDataSetIterator.numExamplesTest(dataSet);
        }
        try {
            this.manager = new MnistManager(this.images, this.labels, this.totalExamples);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            FileUtils.deleteDirectory((File)new File(EMNIST_ROOT));
            new EmnistFetcher(dataSet).downloadAndUntar();
            this.manager = new MnistManager(this.images, this.labels, this.totalExamples);
        }
        this.numOutcomes = EmnistDataSetIterator.numLabels(dataSet);
        this.binarize = binarize;
        this.cursor = 0;
        this.manager.setCurrent(this.cursor);
        this.inputColumns = this.manager.getImages().getEntryLength();
        this.train = train;
        this.shuffle = shuffle;
        this.order = new int[this.totalExamples];
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i] = i;
        }
        this.rng = new Random(rngSeed);
        this.reset();
        this.oneIndexed = dataSet == EMnistSet.LETTERS;
        this.fOrder = true;
    }

    public EmnistDataFetcher(EMnistSet dataSet, boolean binarize, boolean train, boolean shuffle, long rngSeed) throws IOException {
        this(dataSet, binarize, train, shuffle, rngSeed, DL4JResources.getDirectory((ResourceType)ResourceType.DATASET, (String)"EMNIST"));
    }

    private boolean emnistExists(EmnistFetcher e) {
        if (!this.fetcher.getEmnistDataTrain().existsLocally()) {
            return false;
        }
        if (!this.fetcher.getEmnistLabelsTrain().existsLocally()) {
            return false;
        }
        if (!this.fetcher.getEmnistDataTest().existsLocally()) {
            return false;
        }
        return this.fetcher.getEmnistLabelsTest().existsLocally();
    }
}

