/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.core.loader.impl;

import java.io.IOException;
import java.io.InputStream;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.reader.impl.filebatch.FileBatchRecordReader;
import org.deeplearning4j.core.loader.DataSetLoader;
import org.deeplearning4j.datasets.datavec.RecordReaderDataSetIterator;
import org.nd4j.common.loader.FileBatch;
import org.nd4j.common.loader.Source;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class RecordReaderFileBatchLoader
implements DataSetLoader {
    private final RecordReader recordReader;
    private final int batchSize;
    private final int labelIndexFrom;
    private final int labelIndexTo;
    private final int numPossibleLabels;
    private final boolean regression;
    private DataSetPreProcessor preProcessor;

    public RecordReaderFileBatchLoader(RecordReader recordReader, int batchSize, int labelIndex, int numClasses) {
        this(recordReader, batchSize, labelIndex, labelIndex, numClasses, false, null);
    }

    public RecordReaderFileBatchLoader(RecordReader recordReader, int batchSize, int labelIndexFrom, int labelIndexTo, boolean regression) {
        this(recordReader, batchSize, labelIndexFrom, labelIndexTo, -1, regression, null);
    }

    public RecordReaderFileBatchLoader(RecordReader recordReader, int batchSize, int labelIndexFrom, int labelIndexTo, int numPossibleLabels, boolean regression, DataSetPreProcessor preProcessor) {
        this.recordReader = recordReader;
        this.batchSize = batchSize;
        this.labelIndexFrom = labelIndexFrom;
        this.labelIndexTo = labelIndexTo;
        this.numPossibleLabels = numPossibleLabels;
        this.regression = regression;
        this.preProcessor = preProcessor;
    }

    public DataSet load(Source source) throws IOException {
        FileBatch fb = FileBatch.readFromZip((InputStream)source.getInputStream());
        FileBatchRecordReader rr = new FileBatchRecordReader(this.recordReader, fb);
        RecordReaderDataSetIterator iter = new RecordReaderDataSetIterator((RecordReader)rr, null, this.batchSize, this.labelIndexFrom, this.labelIndexTo, this.numPossibleLabels, -1, this.regression);
        if (this.preProcessor != null) {
            iter.setPreProcessor(this.preProcessor);
        }
        DataSet ds = iter.next();
        return ds;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }
}

