/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.evaluation;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.eval.ROC;
import org.deeplearning4j.eval.ROCMultiClass;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.api.LengthUnit;
import org.deeplearning4j.ui.api.Style;
import org.deeplearning4j.ui.components.chart.ChartLine;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.deeplearning4j.ui.components.component.ComponentDiv;
import org.deeplearning4j.ui.components.component.style.StyleDiv;
import org.deeplearning4j.ui.components.table.ComponentTable;
import org.deeplearning4j.ui.components.table.style.StyleTable;
import org.deeplearning4j.ui.components.text.ComponentText;
import org.deeplearning4j.ui.components.text.style.StyleText;
import org.deeplearning4j.ui.standalone.StaticPageUtil;

public class EvaluationTools {
    private static final String ROC_TITLE = "ROC: TPR/Recall (y) vs. FPR (x)";
    private static final String PR_TITLE = "Precision (y) vs. Recall (x)";
    private static final String PR_THRESHOLD_TITLE = "Precision and Recall (y) vs. Classifier Threshold (x)";
    private static final double CHART_WIDTH_PX = 600.0;
    private static final double CHART_HEIGHT_PX = 400.0;
    private static final StyleChart CHART_STYLE = ((StyleChart.Builder)((StyleChart.Builder)((StyleChart.Builder)new StyleChart.Builder().width(600.0, LengthUnit.Px)).height(400.0, LengthUnit.Px)).margin(LengthUnit.Px, Integer.valueOf(60), Integer.valueOf(60), Integer.valueOf(40), Integer.valueOf(10))).strokeWidth(2.0).seriesColors(new Color[]{Color.BLUE, Color.LIGHT_GRAY}).build();
    private static final StyleChart CHART_STYLE_PRECISION_RECALL = ((StyleChart.Builder)((StyleChart.Builder)((StyleChart.Builder)new StyleChart.Builder().width(600.0, LengthUnit.Px)).height(400.0, LengthUnit.Px)).margin(LengthUnit.Px, Integer.valueOf(60), Integer.valueOf(60), Integer.valueOf(40), Integer.valueOf(10))).strokeWidth(2.0).seriesColors(new Color[]{Color.BLUE, Color.GREEN}).build();
    private static final StyleTable TABLE_STYLE = ((StyleTable.Builder)((StyleTable.Builder)new StyleTable.Builder().backgroundColor(Color.WHITE).headerColor(Color.LIGHT_GRAY).borderWidth(1).columnWidths(LengthUnit.Percent, new double[]{50.0, 50.0}).width(400.0, LengthUnit.Px)).height(200.0, LengthUnit.Px)).build();
    private static final StyleDiv OUTER_DIV_STYLE = ((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().width(1200.0, LengthUnit.Px)).height(400.0, LengthUnit.Px)).build();
    private static final StyleDiv INNER_DIV_STYLE = ((StyleDiv.Builder)new StyleDiv.Builder().width(600.0, LengthUnit.Px)).floatValue(StyleDiv.FloatValue.left).build();
    private static final StyleDiv PAD_DIV_STYLE = ((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().width(600.0, LengthUnit.Px)).height(100.0, LengthUnit.Px)).floatValue(StyleDiv.FloatValue.left).build();
    private static final ComponentDiv PAD_DIV = new ComponentDiv((Style)PAD_DIV_STYLE, new Component[0]);
    private static final StyleText HEADER_TEXT_STYLE = new StyleText.Builder().color(Color.BLACK).fontSize(16.0).underline(true).build();
    private static final StyleDiv HEADER_DIV_STYLE = ((StyleDiv.Builder)((StyleDiv.Builder)((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().width(1050.0, LengthUnit.Px)).height(30.0, LengthUnit.Px)).backgroundColor(Color.LIGHT_GRAY)).margin(LengthUnit.Px, Integer.valueOf(5), Integer.valueOf(5), Integer.valueOf(200), Integer.valueOf(10))).floatValue(StyleDiv.FloatValue.left).build();
    private static final StyleDiv HEADER_DIV_PAD_STYLE = ((StyleDiv.Builder)((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().width(1200.0, LengthUnit.Px)).height(150.0, LengthUnit.Px)).backgroundColor(Color.WHITE)).build();
    private static final StyleDiv HEADER_DIV_TEXT_PAD_STYLE = ((StyleDiv.Builder)((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().width(120.0, LengthUnit.Px)).height(30.0, LengthUnit.Px)).backgroundColor(Color.LIGHT_GRAY)).floatValue(StyleDiv.FloatValue.left).build();
    private static final ComponentTable INFO_TABLE = new ComponentTable.Builder(new StyleTable.Builder().backgroundColor(Color.WHITE).borderWidth(0).build()).content((String[][])new String[][]{{"Precision", "(true positives) / (true positives + false positives)"}, {"True Positive Rate (Recall)", "(true positives) / (data positives)"}, {"False Positive Rate", "(false positives) / (data negatives)"}}).build();

    private EvaluationTools() {
    }

    public static void exportRocChartsToHtmlFile(ROC roc, File file) throws IOException {
        String rocAsHtml = EvaluationTools.rocChartToHtml(roc);
        FileUtils.writeStringToFile((File)file, (String)rocAsHtml);
    }

    public static void exportRocChartsToHtmlFile(ROCMultiClass roc, File file) throws Exception {
        String rocAsHtml = EvaluationTools.rocChartToHtml(roc);
        FileUtils.writeStringToFile((File)file, (String)rocAsHtml);
    }

    public static String rocChartToHtml(ROC roc) {
        double[][] points = roc.getResultsAsArray();
        Component c = EvaluationTools.getRocFromPoints(ROC_TITLE, points, roc.getCountActualPositive(), roc.getCountActualNegative(), roc.calculateAUC());
        Component c2 = EvaluationTools.getPRCharts(PR_TITLE, PR_THRESHOLD_TITLE, roc.getPrecisionRecallCurve());
        return StaticPageUtil.renderHTML((Component[])new Component[]{c, c2});
    }

    public static String rocChartToHtml(ROCMultiClass rocMultiClass) {
        return EvaluationTools.rocChartToHtml(rocMultiClass, null);
    }

    public static String rocChartToHtml(ROCMultiClass rocMultiClass, List<String> classNames) {
        long[] actualCountPositive = rocMultiClass.getCountActualPositive();
        long[] actualCountNegative = rocMultiClass.getCountActualNegative();
        ArrayList<Object> components = new ArrayList<Object>(actualCountPositive.length);
        for (int i = 0; i < actualCountPositive.length; ++i) {
            double[][] points = rocMultiClass.getResultsAsArray(i);
            String headerText = "Class " + i;
            if (classNames != null && classNames.size() > i) {
                headerText = headerText + " (" + classNames.get(i) + ")";
            }
            headerText = headerText + " vs. All";
            ComponentDiv headerDivPad = new ComponentDiv((Style)HEADER_DIV_PAD_STYLE, new Component[0]);
            components.add(headerDivPad);
            ComponentDiv headerDivLeft = new ComponentDiv((Style)HEADER_DIV_TEXT_PAD_STYLE, new Component[0]);
            ComponentDiv headerDiv = new ComponentDiv((Style)HEADER_DIV_STYLE, new Component[]{new ComponentText(headerText, HEADER_TEXT_STYLE)});
            Component c = EvaluationTools.getRocFromPoints(ROC_TITLE, points, actualCountPositive[i], actualCountNegative[i], rocMultiClass.calculateAUC(i));
            Component c2 = EvaluationTools.getPRCharts(PR_TITLE, PR_THRESHOLD_TITLE, rocMultiClass.getPrecisionRecallCurve(i));
            components.add(headerDivLeft);
            components.add(headerDiv);
            components.add(c);
            components.add(c2);
        }
        return StaticPageUtil.renderHTML(components);
    }

    private static Component getRocFromPoints(String title, double[][] points, long positiveCount, long negativeCount, double auc) {
        double[] zeroOne = new double[]{0.0, 1.0};
        ChartLine chartLine = ((ChartLine.Builder)((ChartLine.Builder)((ChartLine.Builder)((ChartLine.Builder)new ChartLine.Builder(title, CHART_STYLE).setXMin(Double.valueOf(0.0))).setXMax(Double.valueOf(1.0))).setYMin(Double.valueOf(0.0))).setYMax(Double.valueOf(1.0))).addSeries("ROC", points[0], points[1]).addSeries("", zeroOne, zeroOne).build();
        ComponentTable ct = new ComponentTable.Builder(TABLE_STYLE).header(new String[]{"Field", "Value"}).content((String[][])new String[][]{{"AUC", String.format("%.5f", auc)}, {"Total Data Positive Count", String.valueOf(positiveCount)}, {"Total Data Negative Count", String.valueOf(negativeCount)}}).build();
        ComponentDiv divLeft = new ComponentDiv((Style)INNER_DIV_STYLE, new Component[]{PAD_DIV, ct, PAD_DIV, INFO_TABLE});
        ComponentDiv divRight = new ComponentDiv((Style)INNER_DIV_STYLE, new Component[]{chartLine});
        return new ComponentDiv((Style)OUTER_DIV_STYLE, new Component[]{divLeft, divRight});
    }

    private static Component getPRCharts(String precisionRecallTitle, String prThresholdTitle, List<ROC.PrecisionRecallPoint> prPoints) {
        ComponentDiv divLeft = new ComponentDiv((Style)INNER_DIV_STYLE, new Component[]{EvaluationTools.getPrecisionRecallCurve(precisionRecallTitle, prPoints)});
        ComponentDiv divRight = new ComponentDiv((Style)INNER_DIV_STYLE, new Component[]{EvaluationTools.getPrecisionRecallVsThreshold(prThresholdTitle, prPoints)});
        return new ComponentDiv((Style)OUTER_DIV_STYLE, new Component[]{divLeft, divRight});
    }

    private static Component getPrecisionRecallCurve(String title, List<ROC.PrecisionRecallPoint> precisionRecallPoints) {
        double[] recallX = new double[precisionRecallPoints.size()];
        double[] precisionY = new double[recallX.length];
        for (int i = 0; i < recallX.length; ++i) {
            ROC.PrecisionRecallPoint p = precisionRecallPoints.get(i);
            recallX[i] = p.getRecall();
            precisionY[i] = p.getPrecision();
        }
        return ((ChartLine.Builder)((ChartLine.Builder)((ChartLine.Builder)((ChartLine.Builder)new ChartLine.Builder(title, CHART_STYLE).setXMin(Double.valueOf(0.0))).setXMax(Double.valueOf(1.0))).setYMin(Double.valueOf(0.0))).setYMax(Double.valueOf(1.0))).addSeries("P vs R", recallX, precisionY).build();
    }

    private static Component getPrecisionRecallVsThreshold(String title, List<ROC.PrecisionRecallPoint> precisionRecallPoints) {
        double[] recallY = new double[precisionRecallPoints.size()];
        double[] precisionY = new double[recallY.length];
        double[] thresholdX = new double[recallY.length];
        for (int i = 0; i < recallY.length; ++i) {
            ROC.PrecisionRecallPoint p = precisionRecallPoints.get(i);
            thresholdX[i] = p.getClassiferThreshold();
            recallY[i] = p.getRecall();
            precisionY[i] = p.getPrecision();
        }
        return ((ChartLine.Builder)((ChartLine.Builder)((ChartLine.Builder)((ChartLine.Builder)((ChartLine.Builder)new ChartLine.Builder(title, CHART_STYLE_PRECISION_RECALL).setXMin(Double.valueOf(0.0))).setXMax(Double.valueOf(1.0))).setYMin(Double.valueOf(0.0))).setYMax(Double.valueOf(1.0))).addSeries("Precision", thresholdX, precisionY).addSeries("Recall", thresholdX, recallY).showLegend(true)).build();
    }
}

