/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.Random;
import org.datavec.api.io.labels.ParentPathLabelGenerator;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.image.loader.LFWLoader;
import org.datavec.image.transform.ImageTransform;
import org.deeplearning4j.datasets.datavec.RecordReaderDataSetIterator;

public class LFWDataSetIterator
extends RecordReaderDataSetIterator {
    public LFWDataSetIterator(int[] imgDim) {
        this(1054, 1054, imgDim, 432, false, (PathLabelGenerator)new ParentPathLabelGenerator(), true, 1.0, null, new Random(System.currentTimeMillis()));
    }

    public LFWDataSetIterator(int batchSize, int numExamples) {
        this(batchSize, numExamples, new int[]{250, 250, 3}, 5749, false, LFWLoader.LABEL_PATTERN, true, 1.0, null, new Random(System.currentTimeMillis()));
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int[] imgDim) {
        this(batchSize, numExamples, imgDim, 5749, false, LFWLoader.LABEL_PATTERN, true, 1.0, null, new Random(System.currentTimeMillis()));
    }

    public LFWDataSetIterator(int batchSize, int[] imgDim, boolean useSubset) {
        this(batchSize, useSubset ? 1054 : 13233, imgDim, useSubset ? 432 : 5749, useSubset, LFWLoader.LABEL_PATTERN, true, 1.0, null, new Random(System.currentTimeMillis()));
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int[] imgDim, boolean train, double splitTrainTest) {
        this(batchSize, numExamples, imgDim, 5749, false, LFWLoader.LABEL_PATTERN, train, splitTrainTest, null, new Random(System.currentTimeMillis()));
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int numLabels, boolean train, double splitTrainTest) {
        this(batchSize, numExamples, new int[]{250, 250, 3}, numLabels, false, null, train, splitTrainTest, null, new Random(System.currentTimeMillis()));
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int[] imgDim, int numLabels, boolean useSubset, boolean train, double splitTrainTest, Random rng) {
        this(batchSize, numExamples, imgDim, numLabels, useSubset, LFWLoader.LABEL_PATTERN, train, splitTrainTest, null, rng);
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int[] imgDim, int numLabels, boolean useSubset, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        this(batchSize, numExamples, imgDim, numLabels, useSubset, labelGenerator, train, splitTrainTest, null, rng);
    }

    public LFWDataSetIterator(int batchSize, int numExamples, int[] imgDim, int numLabels, boolean useSubset, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, ImageTransform imageTransform, Random rng) {
        super(new LFWLoader(imgDim, imageTransform, useSubset).getRecordReader(batchSize, numExamples, imgDim, numLabels, labelGenerator, train, splitTrainTest, rng), batchSize, 1, numLabels);
    }
}

