/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.algorithm.strategy;

import org.deeplearning4j.clustering.algorithm.condition.ClusteringAlgorithmCondition;
import org.deeplearning4j.clustering.algorithm.condition.ConvergenceCondition;
import org.deeplearning4j.clustering.algorithm.condition.FixedIterationCountCondition;
import org.deeplearning4j.clustering.algorithm.iteration.IterationHistory;
import org.deeplearning4j.clustering.algorithm.optimisation.ClusteringOptimization;
import org.deeplearning4j.clustering.algorithm.optimisation.ClusteringOptimizationType;
import org.deeplearning4j.clustering.algorithm.strategy.BaseClusteringStrategy;
import org.deeplearning4j.clustering.algorithm.strategy.ClusteringStrategyType;

public class OptimisationStrategy
extends BaseClusteringStrategy {
    public static int defaultIterationCount = 100;
    private ClusteringOptimization clusteringOptimisation;
    private ClusteringAlgorithmCondition clusteringOptimisationApplicationCondition;

    protected OptimisationStrategy() {
    }

    protected OptimisationStrategy(int initialClusterCount, String distanceFunction) {
        super(ClusteringStrategyType.OPTIMIZATION, initialClusterCount, distanceFunction, false);
    }

    public static OptimisationStrategy setup(int initialClusterCount, String distanceFunction) {
        return new OptimisationStrategy(initialClusterCount, distanceFunction);
    }

    public OptimisationStrategy optimize(ClusteringOptimizationType type, double value) {
        this.clusteringOptimisation = new ClusteringOptimization(type, value);
        return this;
    }

    public OptimisationStrategy optimizeWhenIterationCountMultipleOf(int value) {
        this.clusteringOptimisationApplicationCondition = FixedIterationCountCondition.iterationCountGreaterThan(value);
        return this;
    }

    public OptimisationStrategy optimizeWhenPointDistributionVariationRateLessThan(double rate) {
        this.clusteringOptimisationApplicationCondition = ConvergenceCondition.distributionVariationRateLessThan(rate);
        return this;
    }

    public double getClusteringOptimizationValue() {
        return this.clusteringOptimisation.getValue();
    }

    public boolean isClusteringOptimizationType(ClusteringOptimizationType type) {
        return this.clusteringOptimisation != null && this.clusteringOptimisation.getType().equals((Object)type);
    }

    @Override
    public boolean isOptimizationDefined() {
        return this.clusteringOptimisation != null;
    }

    @Override
    public boolean isOptimizationApplicableNow(IterationHistory iterationHistory) {
        return this.clusteringOptimisationApplicationCondition != null && this.clusteringOptimisationApplicationCondition.isSatisfied(iterationHistory);
    }
}

