/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.algorithm.condition;

import java.io.Serializable;
import org.deeplearning4j.clustering.algorithm.condition.ClusteringAlgorithmCondition;
import org.deeplearning4j.clustering.algorithm.iteration.IterationHistory;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.GreaterThanOrEqual;

public class FixedIterationCountCondition
implements ClusteringAlgorithmCondition,
Serializable {
    private Condition iterationCountCondition;

    protected FixedIterationCountCondition() {
    }

    protected FixedIterationCountCondition(int initialClusterCount) {
        this.iterationCountCondition = new GreaterThanOrEqual((Number)initialClusterCount);
    }

    public static FixedIterationCountCondition iterationCountGreaterThan(int iterationCount) {
        return new FixedIterationCountCondition(iterationCount);
    }

    @Override
    public boolean isSatisfied(IterationHistory iterationHistory) {
        return this.iterationCountCondition.apply((Number)(iterationHistory == null ? 0 : iterationHistory.getIterationCount()));
    }
}

