/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.bytedeco.opencv.opencv_core.Mat;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;

public class PipelineImageTransform
extends BaseImageTransform<Mat> {
    protected List<Pair<ImageTransform, Double>> imageTransforms;
    protected boolean shuffle;
    protected Random rng;
    protected List<ImageTransform> currentTransforms = new ArrayList<ImageTransform>();

    public PipelineImageTransform(ImageTransform ... transforms) {
        this(1234L, false, transforms);
    }

    public PipelineImageTransform(long seed, boolean shuffle, ImageTransform ... transforms) {
        super(null);
        LinkedList<Pair<ImageTransform, Double>> pipeline = new LinkedList<Pair<ImageTransform, Double>>();
        for (int i = 0; i < transforms.length; ++i) {
            pipeline.add((Pair<ImageTransform, Double>)new Pair((Object)transforms[i], (Object)1.0));
        }
        this.imageTransforms = pipeline;
        this.shuffle = shuffle;
        this.rng = Nd4j.getRandom();
        this.rng.setSeed(seed);
    }

    public PipelineImageTransform(List<Pair<ImageTransform, Double>> transforms) {
        this(1234L, transforms, false);
    }

    public PipelineImageTransform(List<Pair<ImageTransform, Double>> transforms, boolean shuffle) {
        this(1234L, transforms, shuffle);
    }

    public PipelineImageTransform(long seed, List<Pair<ImageTransform, Double>> transforms) {
        this(seed, transforms, false);
    }

    public PipelineImageTransform(long seed, List<Pair<ImageTransform, Double>> transforms, boolean shuffle) {
        this(null, seed, transforms, shuffle);
    }

    public PipelineImageTransform(java.util.Random random, long seed, List<Pair<ImageTransform, Double>> transforms, boolean shuffle) {
        super(random);
        this.imageTransforms = transforms;
        this.shuffle = shuffle;
        this.rng = Nd4j.getRandom();
        this.rng.setSeed(seed);
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, java.util.Random random) {
        if (this.shuffle) {
            Collections.shuffle(this.imageTransforms);
        }
        this.currentTransforms.clear();
        for (Pair<ImageTransform, Double> tuple : this.imageTransforms) {
            if ((Double)tuple.getSecond() != 1.0 && !(this.rng.nextDouble() < (Double)tuple.getSecond())) continue;
            this.currentTransforms.add((ImageTransform)tuple.getFirst());
            image = random != null ? ((ImageTransform)tuple.getFirst()).transform(image, random) : (ImageWritable)((ImageTransform)tuple.getFirst()).transform(image);
        }
        return image;
    }

    @Override
    public float[] query(float ... coordinates) {
        for (ImageTransform transform : this.currentTransforms) {
            coordinates = transform.query(coordinates);
        }
        return coordinates;
    }

    public List<Pair<ImageTransform, Double>> getImageTransforms() {
        return this.imageTransforms;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public Random getRng() {
        return this.rng;
    }

    public List<ImageTransform> getCurrentTransforms() {
        return this.currentTransforms;
    }

    public void setImageTransforms(List<Pair<ImageTransform, Double>> imageTransforms) {
        this.imageTransforms = imageTransforms;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public void setRng(Random rng) {
        this.rng = rng;
    }

    public void setCurrentTransforms(List<ImageTransform> currentTransforms) {
        this.currentTransforms = currentTransforms;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PipelineImageTransform)) {
            return false;
        }
        PipelineImageTransform other = (PipelineImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Pair<ImageTransform, Double>> this$imageTransforms = this.getImageTransforms();
        List<Pair<ImageTransform, Double>> other$imageTransforms = other.getImageTransforms();
        if (this$imageTransforms == null ? other$imageTransforms != null : !((Object)this$imageTransforms).equals(other$imageTransforms)) {
            return false;
        }
        if (this.isShuffle() != other.isShuffle()) {
            return false;
        }
        Random this$rng = this.getRng();
        Random other$rng = other.getRng();
        if (this$rng == null ? other$rng != null : !this$rng.equals(other$rng)) {
            return false;
        }
        List<ImageTransform> this$currentTransforms = this.getCurrentTransforms();
        List<ImageTransform> other$currentTransforms = other.getCurrentTransforms();
        return !(this$currentTransforms == null ? other$currentTransforms != null : !((Object)this$currentTransforms).equals(other$currentTransforms));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PipelineImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Pair<ImageTransform, Double>> $imageTransforms = this.getImageTransforms();
        result = result * 59 + ($imageTransforms == null ? 43 : ((Object)$imageTransforms).hashCode());
        result = result * 59 + (this.isShuffle() ? 79 : 97);
        Random $rng = this.getRng();
        result = result * 59 + ($rng == null ? 43 : $rng.hashCode());
        List<ImageTransform> $currentTransforms = this.getCurrentTransforms();
        result = result * 59 + ($currentTransforms == null ? 43 : ((Object)$currentTransforms).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PipelineImageTransform(imageTransforms=" + this.getImageTransforms() + ", shuffle=" + this.isShuffle() + ", rng=" + this.getRng() + ", currentTransforms=" + this.getCurrentTransforms() + ")";
    }

    public static class Builder {
        protected List<Pair<ImageTransform, Double>> imageTransforms = new ArrayList<Pair<ImageTransform, Double>>();
        protected Long seed = null;

        public Builder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder addImageTransform(@NonNull ImageTransform transform) {
            if (transform == null) {
                throw new NullPointerException("transform is marked non-null but is null");
            }
            return this.addImageTransform(transform, 1.0);
        }

        public Builder addImageTransform(@NonNull ImageTransform transform, Double probability) {
            if (transform == null) {
                throw new NullPointerException("transform is marked non-null but is null");
            }
            if (probability < 0.0) {
                probability = 0.0;
            }
            if (probability > 1.0) {
                probability = 1.0;
            }
            this.imageTransforms.add((Pair<ImageTransform, Double>)Pair.makePair((Object)transform, (Object)probability));
            return this;
        }

        public PipelineImageTransform build() {
            if (this.seed != null) {
                return new PipelineImageTransform(this.seed, this.imageTransforms);
            }
            return new PipelineImageTransform(this.imageTransforms);
        }
    }
}

