/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.Frame;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;

public class ShowImageTransform
extends BaseImageTransform {
    CanvasFrame canvas;
    String title;
    int delay;

    public ShowImageTransform(CanvasFrame canvas) {
        this(canvas, -1);
    }

    public ShowImageTransform(CanvasFrame canvas, int delay) {
        super(null);
        this.canvas = canvas;
        this.delay = delay;
    }

    public ShowImageTransform(String title) {
        this(title, -1);
    }

    public ShowImageTransform(String title, int delay) {
        super(null);
        this.canvas = null;
        this.title = title;
        this.delay = delay;
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (this.canvas == null) {
            this.canvas = new CanvasFrame(this.title, 1.0);
            this.canvas.setDefaultCloseOperation(2);
        }
        if (image == null) {
            this.canvas.dispose();
            return null;
        }
        if (!this.canvas.isVisible()) {
            return image;
        }
        Frame frame = image.getFrame();
        this.canvas.setCanvasSize(frame.imageWidth, frame.imageHeight);
        this.canvas.showImage(frame);
        if (this.delay >= 0) {
            try {
                this.canvas.waitKey(this.delay);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        return image;
    }

    @Override
    public float[] query(float ... coordinates) {
        return coordinates;
    }

    public CanvasFrame getCanvas() {
        return this.canvas;
    }

    public String getTitle() {
        return this.title;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setCanvas(CanvasFrame canvas) {
        this.canvas = canvas;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShowImageTransform)) {
            return false;
        }
        ShowImageTransform other = (ShowImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CanvasFrame this$canvas = this.getCanvas();
        CanvasFrame other$canvas = other.getCanvas();
        if (this$canvas == null ? other$canvas != null : !this$canvas.equals(other$canvas)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        return this.getDelay() == other.getDelay();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ShowImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CanvasFrame $canvas = this.getCanvas();
        result = result * 59 + ($canvas == null ? 43 : $canvas.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + this.getDelay();
        return result;
    }

    @Override
    public String toString() {
        return "ShowImageTransform(canvas=" + this.getCanvas() + ", title=" + this.getTitle() + ", delay=" + this.getDelay() + ")";
    }
}

