/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.io.serializers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.datavec.api.conf.Configuration;
import org.datavec.api.conf.Configured;
import org.datavec.api.io.serializers.Deserializer;
import org.datavec.api.io.serializers.Serialization;
import org.datavec.api.io.serializers.Serializer;
import org.datavec.api.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationFactory
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger((String)SerializationFactory.class.getName());
    private List<Serialization<?>> serializations = new ArrayList();

    public SerializationFactory(Configuration conf) {
        super(conf);
        for (String serializerName : conf.getStrings("io.serializations", "org.apache.hadoop.io.serializer.WritableSerialization")) {
            this.add(conf, serializerName);
        }
    }

    private void add(Configuration conf, String serializationName) {
        try {
            Class<?> serializationClass = conf.getClassByName(serializationName);
            this.serializations.add((Serialization<?>)ReflectionUtils.newInstance(serializationClass, this.getConf()));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Serialization class not found: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public <T> Serializer<T> getSerializer(Class<T> c) {
        return this.getSerialization(c).getSerializer(c);
    }

    public <T> Deserializer<T> getDeserializer(Class<T> c) {
        return this.getSerialization(c).getDeserializer(c);
    }

    public <T> Serialization<T> getSerialization(Class<T> c) {
        for (Serialization<T> serialization : this.serializations) {
            if (!serialization.accept(c)) continue;
            return serialization;
        }
        return null;
    }
}

