/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ops;

import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.writable.Writable;

public class AggregableCheckingOp<T>
implements IAggregableReduceOp<Writable, T> {
    private IAggregableReduceOp<Writable, T> operation;
    private ColumnMetaData metaData;

    @Override
    public <W extends IAggregableReduceOp<Writable, T>> void combine(W accu) {
        AggregableCheckingOp accumulator;
        if (accu instanceof AggregableCheckingOp) {
            accumulator = (AggregableCheckingOp)accu;
            if (this.metaData.getColumnType() != accumulator.getMetaData().getColumnType()) {
                throw new IllegalArgumentException("Invalid merge with operation on " + accumulator.getMetaData().getName() + " of type " + (Object)((Object)accumulator.getMetaData().getColumnType()) + " expected " + this.metaData.getName() + " of type " + (Object)((Object)this.metaData.getColumnType()));
            }
        } else {
            throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
        }
        this.operation.combine(accumulator);
    }

    public void accept(Writable writable) {
        if (this.metaData.isValid(writable)) {
            this.operation.accept(writable);
        }
    }

    public T get() {
        return (T)this.operation.get();
    }

    public AggregableCheckingOp(IAggregableReduceOp<Writable, T> operation, ColumnMetaData metaData) {
        this.operation = operation;
        this.metaData = metaData;
    }

    public void setOperation(IAggregableReduceOp<Writable, T> operation) {
        this.operation = operation;
    }

    public void setMetaData(ColumnMetaData metaData) {
        this.metaData = metaData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregableCheckingOp)) {
            return false;
        }
        AggregableCheckingOp other = (AggregableCheckingOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IAggregableReduceOp<Writable, T> this$operation = this.getOperation();
        IAggregableReduceOp<Writable, T> other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        ColumnMetaData this$metaData = this.getMetaData();
        ColumnMetaData other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregableCheckingOp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IAggregableReduceOp<Writable, T> $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        ColumnMetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        return result;
    }

    public String toString() {
        return "AggregableCheckingOp(operation=" + this.getOperation() + ", metaData=" + this.getMetaData() + ")";
    }

    public IAggregableReduceOp<Writable, T> getOperation() {
        return this.operation;
    }

    public ColumnMetaData getMetaData() {
        return this.metaData;
    }
}

