/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util.files;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ShuffledListIterator<T>
implements Iterator<T> {
    private final List<T> list;
    private final int[] order;
    private int currentPosition = 0;

    public ShuffledListIterator(List<T> list, int[] order) {
        if (order != null && list.size() != order.length) {
            throw new IllegalArgumentException("Order array and list sizes differ");
        }
        this.list = list;
        this.order = order;
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.list.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int nextPos = this.order != null ? this.order[this.currentPosition] : this.currentPosition;
        ++this.currentPosition;
        return this.list.get(nextPos);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

