/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.writer.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.partition.Partitioner;

public abstract class FileRecordWriter
implements RecordWriter {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected DataOutputStream out;
    public static final String NEW_LINE = "\n";
    protected Charset encoding = DEFAULT_CHARSET;
    protected Partitioner partitioner;
    protected Configuration conf;

    @Override
    public void initialize(InputSplit inputSplit, Partitioner partitioner) throws Exception {
        partitioner.init(inputSplit);
        this.out = new DataOutputStream(partitioner.currentOutputStream());
        this.partitioner = partitioner;
    }

    @Override
    public void initialize(Configuration configuration, InputSplit split, Partitioner partitioner) throws Exception {
        this.setConf(configuration);
        partitioner.init(configuration, split);
        this.initialize(split, partitioner);
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

