/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.quality.categorical;

import java.io.Serializable;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.quality.columns.CategoricalQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.function.BiFunction;

public class CategoricalQualityAddFunction
implements BiFunction<CategoricalQuality, Writable, CategoricalQuality>,
Serializable {
    private final CategoricalMetaData meta;

    public CategoricalQuality apply(CategoricalQuality v1, Writable writable) {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        return new CategoricalQuality(valid, invalid, countMissing, countTotal);
    }

    public CategoricalQualityAddFunction(CategoricalMetaData meta) {
        this.meta = meta;
    }
}

