/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;

public class BytesAnalysis
implements ColumnAnalysis {
    private long countTotal;
    private long countNull;
    private long countZeroLength;
    private int minNumBytes;
    private int maxNumBytes;

    public BytesAnalysis(Builder builder) {
        this.countTotal = builder.countTotal;
        this.countNull = builder.countNull;
        this.countZeroLength = builder.countZeroLength;
        this.minNumBytes = builder.minNumBytes;
        this.maxNumBytes = builder.maxNumBytes;
    }

    public String toString() {
        return "BytesAnalysis()";
    }

    @Override
    public long getCountTotal() {
        return this.countTotal;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Bytes;
    }

    public BytesAnalysis(long countTotal, long countNull, long countZeroLength, int minNumBytes, int maxNumBytes) {
        this.countTotal = countTotal;
        this.countNull = countNull;
        this.countZeroLength = countZeroLength;
        this.minNumBytes = minNumBytes;
        this.maxNumBytes = maxNumBytes;
    }

    public long getCountNull() {
        return this.countNull;
    }

    public long getCountZeroLength() {
        return this.countZeroLength;
    }

    public int getMinNumBytes() {
        return this.minNumBytes;
    }

    public int getMaxNumBytes() {
        return this.maxNumBytes;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public void setCountNull(long countNull) {
        this.countNull = countNull;
    }

    public void setCountZeroLength(long countZeroLength) {
        this.countZeroLength = countZeroLength;
    }

    public void setMinNumBytes(int minNumBytes) {
        this.minNumBytes = minNumBytes;
    }

    public void setMaxNumBytes(int maxNumBytes) {
        this.maxNumBytes = maxNumBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BytesAnalysis)) {
            return false;
        }
        BytesAnalysis other = (BytesAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountTotal() != other.getCountTotal()) {
            return false;
        }
        if (this.getCountNull() != other.getCountNull()) {
            return false;
        }
        if (this.getCountZeroLength() != other.getCountZeroLength()) {
            return false;
        }
        if (this.getMinNumBytes() != other.getMinNumBytes()) {
            return false;
        }
        return this.getMaxNumBytes() == other.getMaxNumBytes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BytesAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        long $countNull = this.getCountNull();
        result = result * 59 + (int)($countNull >>> 32 ^ $countNull);
        long $countZeroLength = this.getCountZeroLength();
        result = result * 59 + (int)($countZeroLength >>> 32 ^ $countZeroLength);
        result = result * 59 + this.getMinNumBytes();
        result = result * 59 + this.getMaxNumBytes();
        return result;
    }

    public BytesAnalysis() {
    }

    public static class Builder {
        private long countTotal;
        private long countNull;
        private long countZeroLength;
        private int minNumBytes;
        private int maxNumBytes;

        public Builder countTotal(long countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        public Builder countNull(long countNull) {
            this.countNull = countNull;
            return this;
        }

        public Builder countZeroLength(long countZeroLength) {
            this.countZeroLength = countZeroLength;
            return this;
        }

        public Builder minNumBytes(int minNumBytes) {
            this.minNumBytes = minNumBytes;
            return this;
        }

        public Builder maxNumBytes(int maxNumBytes) {
            this.maxNumBytes = maxNumBytes;
            return this;
        }

        public BytesAnalysis build() {
            return new BytesAnalysis(this);
        }
    }
}

