/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.jackson;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataURI;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.reader.impl.FileRecordReader;
import org.datavec.api.records.reader.impl.jackson.FieldSelection;
import org.datavec.api.records.reader.impl.jackson.JacksonReaderUtils;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public class JacksonLineSequenceRecordReader
extends FileRecordReader
implements SequenceRecordReader {
    private FieldSelection selection;
    private ObjectMapper mapper;

    public JacksonLineSequenceRecordReader(FieldSelection selection, ObjectMapper mapper) {
        this.selection = selection;
        this.mapper = mapper;
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        return this.nextSequence().getSequenceRecord();
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        return this.loadAndClose(dataInputStream);
    }

    @Override
    public SequenceRecord nextSequence() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        URI next = (URI)this.locationsIterator.next();
        List<List<Writable>> out = this.loadAndClose((InputStream)this.streamCreatorFn.apply((Object)next));
        return new org.datavec.api.records.impl.SequenceRecord(out, new RecordMetaDataURI(next));
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return null;
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<SequenceRecord> out = new ArrayList<SequenceRecord>();
        for (RecordMetaData m : recordMetaDatas) {
            out.add(this.loadSequenceFromMetaData(m));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Writable>> loadAndClose(InputStream inputStream) {
        List<List<Writable>> list;
        block6: {
            LineIterator lineIter = null;
            try {
                lineIter = IOUtils.lineIterator((Reader)new BufferedReader(new InputStreamReader(inputStream)));
                list = this.load((Iterator<String>)lineIter);
                if (lineIter == null) break block6;
            }
            catch (Throwable throwable) {
                if (lineIter != null) {
                    lineIter.close();
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            lineIter.close();
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return list;
    }

    private List<List<Writable>> load(Iterator<String> lineIter) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        while (lineIter.hasNext()) {
            out.add(JacksonReaderUtils.parseRecord(lineIter.next(), this.selection, this.mapper));
        }
        return out;
    }
}

