/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query.namedparameter;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;

public class NamedTransformedSqlFactory {
    private final Map<CacheKey, NamedTransformedSql> namedTransformedSqls = Collections.synchronizedMap(new WeakHashMap());

    public NamedTransformedSql create(String string, Map<String, ?> map) {
        CacheKey cacheKey = this.cacheKey(string, map);
        NamedTransformedSql namedTransformedSql = this.namedTransformedSqls.get(cacheKey);
        if (namedTransformedSql == null) {
            namedTransformedSql = NamedTransformedSql.forSqlAndParams(string, map);
            this.namedTransformedSqls.put(cacheKey, namedTransformedSql);
        }
        return namedTransformedSql;
    }

    public static boolean hasCollection(Map<String, ?> map) {
        return map.values().stream().filter(object -> object instanceof Collection).findFirst().isPresent();
    }

    private CacheKey cacheKey(String string, Map<String, ?> map) {
        Optional optional = NamedTransformedSqlFactory.hasCollection(map) ? Optional.of(Collections.unmodifiableMap(new TreeMap(map).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() instanceof Collection ? ((Collection)entry.getValue()).size() : 1)))) : Optional.empty();
        return new CacheKey(string, optional);
    }

    private static class CacheKey {
        private final String sql;
        private final Optional<Map<String, Integer>> paramCounts;

        private CacheKey(String string, Optional<Map<String, Integer>> optional) {
            this.sql = string;
            this.paramCounts = optional;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (!this.sql.equals(cacheKey.sql)) {
                return false;
            }
            return this.paramCounts.equals(cacheKey.paramCounts);
        }

        public int hashCode() {
            int n = this.sql.hashCode();
            n = 31 * n + this.paramCounts.hashCode();
            return n;
        }
    }
}

