/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.DefaultContext;

public abstract class PlexusTestCase
extends TestCase {
    protected PlexusContainer container;
    protected Map context;
    private static String basedir;

    /*
     * Unable to fully structure code
     */
    protected void setUp() throws Exception {
        PlexusTestCase.basedir = PlexusTestCase.getBasedir();
        this.context = new HashMap<K, V>();
        this.context.put("basedir", PlexusTestCase.getBasedir());
        this.customizeContext(new DefaultContext(this.context));
        hasPlexusHome = this.context.containsKey("plexus.home");
        if (!hasPlexusHome) {
            f = PlexusTestCase.getTestFile("target/plexus-home");
            if (!f.isDirectory()) {
                f.mkdir();
            }
            this.context.put("plexus.home", f.getAbsolutePath());
        }
        if ((config = this.getCustomConfigurationName()) != null) {
            is = this.getClassLoader().getResourceAsStream(config);
            if (is == null) {
                try {
                    configFile = new File(config);
                    if (!configFile.exists()) ** GOTO lbl27
                    is = new FileInputStream(configFile);
                }
                catch (IOException e) {
                    throw new Exception("The custom configuration specified is null: " + config);
                }
            }
        } else {
            config = this.getConfigurationName(null);
            is = this.getClassLoader().getResourceAsStream(config);
        }
lbl27:
        // 4 sources

        if (is == null) {
            config = null;
        } else {
            is.close();
        }
        this.container = this.createContainerInstance(this.context, config);
    }

    protected PlexusContainer createContainerInstance(Map context, String configuration) throws PlexusContainerException {
        return new DefaultPlexusContainer("test", context, configuration);
    }

    protected void customizeContext(Context context) throws Exception {
    }

    protected void tearDown() throws Exception {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    protected PlexusContainer getContainer() {
        return this.container;
    }

    protected InputStream getConfiguration() throws Exception {
        return this.getConfiguration(null);
    }

    protected InputStream getConfiguration(String subname) throws Exception {
        return this.getResourceAsStream(this.getConfigurationName(subname));
    }

    protected String getCustomConfigurationName() {
        return null;
    }

    protected String getConfigurationName(String subname) throws Exception {
        return ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".xml";
    }

    protected InputStream getResourceAsStream(String resource) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resource);
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected Object lookup(String componentKey) throws Exception {
        return this.getContainer().lookup(componentKey);
    }

    protected Object lookup(String role, String id) throws Exception {
        return this.getContainer().lookup(role, id);
    }

    protected Object lookup(Class componentClass) throws Exception {
        return this.getContainer().lookup(componentClass);
    }

    protected Object lookup(Class role, String id) throws Exception {
        return this.getContainer().lookup(role, id);
    }

    protected void release(Object component) throws Exception {
        this.getContainer().release(component);
    }

    public static File getTestFile(String path) {
        return new File(PlexusTestCase.getBasedir(), path);
    }

    public static File getTestFile(String basedir, String path) {
        File basedirFile = new File(basedir);
        if (!basedirFile.isAbsolute()) {
            basedirFile = PlexusTestCase.getTestFile(basedir);
        }
        return new File(basedirFile, path);
    }

    public static String getTestPath(String path) {
        return PlexusTestCase.getTestFile(path).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path) {
        return PlexusTestCase.getTestFile(basedir, path).getAbsolutePath();
    }

    public static String getBasedir() {
        if (basedir != null) {
            return basedir;
        }
        basedir = System.getProperty("basedir");
        if (basedir == null) {
            basedir = new File("").getAbsolutePath();
        }
        return basedir;
    }

    public String getTestConfiguration() {
        return PlexusTestCase.getTestConfiguration(((Object)((Object)this)).getClass());
    }

    public static String getTestConfiguration(Class clazz) {
        String s = clazz.getName().replace('.', '/');
        return s.substring(0, s.indexOf("$")) + ".xml";
    }
}

