/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeLocator {
    private List<String> sourceRoots;
    private Map<String, File> cache;

    public SourceCodeLocator(List<String> sourceRoots) {
        this.sourceRoots = sourceRoots;
        this.cache = new HashMap<String, File>();
    }

    public File findSourceCodeForClass(String className) {
        File f = this.cache.get(className);
        if (f != null) {
            return f;
        }
        String sourceName = className.replace('.', System.getProperty("file.separator").charAt(0));
        sourceName = sourceName + ".java";
        f = this.findInRoots(sourceName);
        this.cache.put(className, f);
        return f;
    }

    private File findInRoots(String s) {
        try {
            for (String root : this.sourceRoots) {
                File f = new File(root, s);
                if (!f.exists() || !f.getName().equals(f.getCanonicalFile().getName())) continue;
                return f;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

