/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.javacutil.TreeUtils;

public class NullChkNode
extends Node {
    protected final Tree tree;
    protected final Node operand;

    public NullChkNode(Tree tree, Node operand) {
        super(TreeUtils.typeOf((Tree)tree));
        assert (tree.getKind() == Tree.Kind.OTHER);
        this.tree = tree;
        this.operand = operand;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitNullChk(this, p);
    }

    public String toString() {
        return "(+ " + this.getOperand() + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof NumericalPlusNode)) {
            return false;
        }
        NumericalPlusNode other = (NumericalPlusNode)obj;
        return this.getOperand().equals(other.getOperand());
    }

    public int hashCode() {
        return Objects.hash(NullChkNode.class, this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

