/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import org.checkerframework.javacutil.SystemUtil;

public abstract class UnderlyingAST {
    protected final Kind kind;

    protected UnderlyingAST(Kind kind) {
        this.kind = kind;
    }

    public abstract Tree getCode();

    public Kind getKind() {
        return this.kind;
    }

    public static class CFGStatement
    extends UnderlyingAST {
        protected final Tree code;
        protected final ClassTree classTree;

        public CFGStatement(Tree code, ClassTree classTree) {
            super(Kind.ARBITRARY_CODE);
            this.code = code;
            this.classTree = classTree;
        }

        @Override
        public Tree getCode() {
            return this.code;
        }

        public ClassTree getClassTree() {
            return this.classTree;
        }

        public String toString() {
            return SystemUtil.joinLines((Object[])new Object[]{"CFGStatement(", this.code, ")"});
        }
    }

    public static class CFGLambda
    extends UnderlyingAST {
        private final LambdaExpressionTree lambda;
        private final ClassTree classTree;
        private final MethodTree method;

        public CFGLambda(LambdaExpressionTree lambda, ClassTree classTree, MethodTree method) {
            super(Kind.LAMBDA);
            this.lambda = lambda;
            this.method = method;
            this.classTree = classTree;
        }

        @Override
        public Tree getCode() {
            return this.lambda.getBody();
        }

        public LambdaExpressionTree getLambdaTree() {
            return this.lambda;
        }

        public ClassTree getClassTree() {
            return this.classTree;
        }

        public MethodTree getMethod() {
            return this.method;
        }

        public String toString() {
            return SystemUtil.joinLines((Object[])new Object[]{"CFGLambda(", this.lambda, ")"});
        }
    }

    public static class CFGMethod
    extends UnderlyingAST {
        protected final MethodTree method;
        protected final ClassTree classTree;

        public CFGMethod(MethodTree method, ClassTree classTree) {
            super(Kind.METHOD);
            this.method = method;
            this.classTree = classTree;
        }

        @Override
        public Tree getCode() {
            return this.method.getBody();
        }

        public MethodTree getMethod() {
            return this.method;
        }

        public ClassTree getClassTree() {
            return this.classTree;
        }

        public String toString() {
            return SystemUtil.joinLines((Object[])new Object[]{"CFGMethod(", this.method, ")"});
        }
    }

    public static enum Kind {
        METHOD,
        LAMBDA,
        ARBITRARY_CODE;

    }
}

