/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.Node;

public class TransferInput<V extends AbstractValue<V>, S extends Store<S>> {
    protected @Nullable Node node;
    protected final @Nullable S store;
    protected final @Nullable S thenStore;
    protected final @Nullable S elseStore;
    protected final Analysis<V, S, ?> analysis;

    public TransferInput(Node n, Analysis<V, S, ?> analysis, TransferResult<V, S> to) {
        this.node = n;
        this.analysis = analysis;
        if (to.containsTwoStores()) {
            this.thenStore = to.getThenStore();
            this.elseStore = to.getElseStore();
            this.store = null;
        } else {
            this.store = to.getRegularStore();
            this.elseStore = null;
            this.thenStore = null;
        }
    }

    public TransferInput(@Nullable Node n, Analysis<V, S, ?> analysis, S s) {
        this.node = n;
        this.analysis = analysis;
        this.store = s;
        this.elseStore = null;
        this.thenStore = null;
    }

    public TransferInput(@Nullable Node n, Analysis<V, S, ?> analysis, S s1, S s2) {
        this.node = n;
        this.analysis = analysis;
        this.thenStore = s1;
        this.elseStore = s2;
        this.store = null;
    }

    protected TransferInput(TransferInput<V, S> from) {
        this.node = from.node;
        this.analysis = from.analysis;
        if (from.store == null) {
            assert (from.thenStore != null && from.elseStore != null) : "@AssumeAssertion(nullness): invariant";
            this.thenStore = from.thenStore.copy();
            this.elseStore = from.elseStore.copy();
            this.store = null;
        } else {
            this.store = from.store.copy();
            this.elseStore = null;
            this.thenStore = null;
        }
    }

    public @Nullable Node getNode() {
        return this.node;
    }

    public @Nullable V getValueOfSubNode(Node n) {
        return this.analysis.getValue(n);
    }

    public S getRegularStore() {
        if (this.store == null) {
            assert (this.thenStore != null && this.elseStore != null) : "@AssumeAssertion(nullness): invariant";
            return this.thenStore.leastUpperBound(this.elseStore);
        }
        return this.store;
    }

    public S getThenStore() {
        if (this.store == null) {
            assert (this.thenStore != null) : "@AssumeAssertion(nullness): invariant";
            return this.thenStore;
        }
        return this.store;
    }

    public S getElseStore() {
        if (this.store == null) {
            assert (this.elseStore != null) : "@AssumeAssertion(nullness): invariant";
            return this.elseStore;
        }
        return this.store.copy();
    }

    public boolean containsTwoStores() {
        return this.store == null;
    }

    public TransferInput<V, S> copy() {
        return new TransferInput<V, S>(this);
    }

    public TransferInput<V, S> leastUpperBound(TransferInput<V, S> other) {
        if (this.store == null) {
            S newThenStore = this.getThenStore().leastUpperBound(other.getThenStore());
            S newElseStore = this.getElseStore().leastUpperBound(other.getElseStore());
            return new TransferInput<V, S>(this.node, this.analysis, newThenStore, newElseStore);
        }
        if (other.store == null) {
            return other.leastUpperBound(this);
        }
        return new TransferInput<V, S>(this.node, this.analysis, this.store.leastUpperBound(other.getRegularStore()));
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof TransferInput) {
            TransferInput other = (TransferInput)o;
            if (this.containsTwoStores()) {
                if (other.containsTwoStores()) {
                    return this.getThenStore().equals(other.getThenStore()) && this.getElseStore().equals(other.getElseStore());
                }
            } else if (!other.containsTwoStores()) {
                return this.getRegularStore().equals(other.getRegularStore());
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.analysis, this.node, this.store, this.thenStore, this.elseStore);
    }

    public String toString() {
        if (this.store == null) {
            return "[then=" + this.thenStore + ", else=" + this.elseStore + "]";
        }
        return "[" + this.store + "]";
    }
}

