/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.interning.qual.EqualsMethod;
import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypeAnnotationUtils;
import org.checkerframework.javacutil.TypesUtils;

public class FlowExpressions {
    public static FieldAccess internalReprOfFieldAccess(AnnotationProvider provider, FieldAccessNode node) {
        Node receiverNode = node.getReceiver();
        Receiver receiver = node.isStatic() ? new ClassName(receiverNode.getType()) : FlowExpressions.internalReprOf(provider, receiverNode);
        return new FieldAccess(receiver, node);
    }

    public static ArrayAccess internalReprOfArrayAccess(AnnotationProvider provider, ArrayAccessNode node) {
        Receiver receiver = FlowExpressions.internalReprOf(provider, node.getArray());
        Receiver index = FlowExpressions.internalReprOf(provider, node.getIndex());
        return new ArrayAccess(node.getType(), receiver, index);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, Node receiverNode) {
        return FlowExpressions.internalReprOf(provider, receiverNode, false);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, Node receiverNode, boolean allowNonDeterministic) {
        Receiver receiver = null;
        if (receiverNode instanceof FieldAccessNode) {
            FieldAccessNode fan = (FieldAccessNode)receiverNode;
            receiver = fan.getFieldName().equals("this") ? new ThisReference(fan.getReceiver().getType()) : (fan.getFieldName().equals("class") ? new ClassName(fan.getReceiver().getType()) : FlowExpressions.internalReprOfFieldAccess(provider, fan));
        } else if (receiverNode instanceof ExplicitThisLiteralNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof ThisLiteralNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof SuperNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof LocalVariableNode) {
            LocalVariableNode lv = (LocalVariableNode)receiverNode;
            receiver = new LocalVariable(lv);
        } else if (receiverNode instanceof ArrayAccessNode) {
            ArrayAccessNode a = (ArrayAccessNode)receiverNode;
            receiver = FlowExpressions.internalReprOfArrayAccess(provider, a);
        } else {
            if (receiverNode instanceof StringConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((StringConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof WideningConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((WideningConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof NarrowingConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((NarrowingConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof BinaryOperationNode) {
                BinaryOperationNode bopn = (BinaryOperationNode)receiverNode;
                return new BinaryOperation(bopn, FlowExpressions.internalReprOf(provider, bopn.getLeftOperand(), allowNonDeterministic), FlowExpressions.internalReprOf(provider, bopn.getRightOperand(), allowNonDeterministic));
            }
            if (receiverNode instanceof ClassNameNode) {
                ClassNameNode cn = (ClassNameNode)receiverNode;
                receiver = new ClassName(cn.getType());
            } else if (receiverNode instanceof ValueLiteralNode) {
                ValueLiteralNode vn = (ValueLiteralNode)receiverNode;
                receiver = new ValueLiteral(vn.getType(), vn);
            } else if (receiverNode instanceof ArrayCreationNode) {
                ArrayCreationNode an = (ArrayCreationNode)receiverNode;
                ArrayList<Receiver> dimensions = new ArrayList<Receiver>();
                for (Node node : an.getDimensions()) {
                    dimensions.add(FlowExpressions.internalReprOf(provider, node, allowNonDeterministic));
                }
                ArrayList<Receiver> initializers = new ArrayList<Receiver>();
                for (Node initializer : an.getInitializers()) {
                    initializers.add(FlowExpressions.internalReprOf(provider, initializer, allowNonDeterministic));
                }
                receiver = new ArrayCreation(an.getType(), dimensions, initializers);
            } else if (receiverNode instanceof MethodInvocationNode) {
                MethodInvocationNode mn = (MethodInvocationNode)receiverNode;
                MethodInvocationTree t = mn.getTree();
                if (t == null) {
                    throw new BugInCF("Unexpected null tree for node: " + mn);
                }
                assert (TreeUtils.isUseOfElement((ExpressionTree)t)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement invokedMethod = TreeUtils.elementFromUse((MethodInvocationTree)t);
                if (allowNonDeterministic || PurityUtils.isDeterministic(provider, invokedMethod)) {
                    ArrayList<Receiver> arrayList = new ArrayList<Receiver>();
                    for (Node p : mn.getArguments()) {
                        arrayList.add(FlowExpressions.internalReprOf(provider, p));
                    }
                    Receiver methodReceiver = ElementUtils.isStatic((Element)invokedMethod) ? new ClassName(mn.getTarget().getReceiver().getType()) : FlowExpressions.internalReprOf(provider, mn.getTarget().getReceiver());
                    receiver = new MethodCall(mn.getType(), invokedMethod, methodReceiver, arrayList);
                }
            }
        }
        if (receiver == null) {
            receiver = new Unknown(receiverNode.getType());
        }
        return receiver;
    }

    public static Receiver internalReprOf(AnnotationProvider provider, ExpressionTree receiverTree) {
        return FlowExpressions.internalReprOf(provider, receiverTree, true);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, ExpressionTree receiverTree, boolean allowNonDeterministic) {
        Receiver receiver;
        block0 : switch (receiverTree.getKind()) {
            case ARRAY_ACCESS: {
                ArrayAccessTree a = (ArrayAccessTree)receiverTree;
                Receiver arrayAccessExpression = FlowExpressions.internalReprOf(provider, a.getExpression());
                Receiver index = FlowExpressions.internalReprOf(provider, a.getIndex());
                receiver = new ArrayAccess(TreeUtils.typeOf((Tree)a), arrayAccessExpression, index);
                break;
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case NULL_LITERAL: 
            case STRING_LITERAL: {
                LiteralTree vn = (LiteralTree)receiverTree;
                receiver = new ValueLiteral(TreeUtils.typeOf((Tree)receiverTree), vn.getValue());
                break;
            }
            case NEW_ARRAY: {
                NewArrayTree newArrayTree = (NewArrayTree)receiverTree;
                ArrayList<Receiver> dimensions = new ArrayList<Receiver>();
                if (newArrayTree.getDimensions() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getDimensions()) {
                        dimensions.add(FlowExpressions.internalReprOf(provider, expressionTree, allowNonDeterministic));
                    }
                }
                ArrayList<Receiver> initializers = new ArrayList<Receiver>();
                if (newArrayTree.getInitializers() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
                        initializers.add(FlowExpressions.internalReprOf(provider, expressionTree, allowNonDeterministic));
                    }
                }
                receiver = new ArrayCreation(TreeUtils.typeOf((Tree)receiverTree), dimensions, initializers);
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)receiverTree;
                assert (TreeUtils.isUseOfElement((ExpressionTree)methodInvocationTree)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement executableElement = TreeUtils.elementFromUse((MethodInvocationTree)methodInvocationTree);
                if (PurityUtils.isDeterministic(provider, executableElement) || allowNonDeterministic) {
                    ExpressionTree expressionTree;
                    ArrayList<Receiver> parameters = new ArrayList<Receiver>();
                    for (ExpressionTree expressionTree2 : methodInvocationTree.getArguments()) {
                        parameters.add(FlowExpressions.internalReprOf(provider, expressionTree2));
                    }
                    Receiver methodReceiver = ElementUtils.isStatic((Element)executableElement) ? new ClassName(TreeUtils.typeOf((Tree)methodInvocationTree.getMethodSelect())) : ((expressionTree = TreeUtils.getReceiverTree((ExpressionTree)methodInvocationTree)) != null ? FlowExpressions.internalReprOf(provider, expressionTree) : FlowExpressions.internalReprOfImplicitReceiver(executableElement));
                    TypeMirror typeMirror = TreeUtils.typeOf((Tree)methodInvocationTree);
                    receiver = new MethodCall(typeMirror, executableElement, methodReceiver, parameters);
                    break;
                }
                receiver = null;
                break;
            }
            case MEMBER_SELECT: {
                receiver = FlowExpressions.internalReprOfMemberSelect(provider, (MemberSelectTree)receiverTree);
                break;
            }
            case IDENTIFIER: {
                IdentifierTree identifierTree = (IdentifierTree)receiverTree;
                TypeMirror typeOfId = TreeUtils.typeOf((Tree)identifierTree);
                if (identifierTree.getName().contentEquals("this") || identifierTree.getName().contentEquals("super")) {
                    receiver = new ThisReference(typeOfId);
                    break;
                }
                assert (TreeUtils.isUseOfElement((ExpressionTree)identifierTree)) : "@AssumeAssertion(nullness): tree kind";
                Element element = TreeUtils.elementFromUse((ExpressionTree)identifierTree);
                if (ElementUtils.isClassElement((Element)element)) {
                    receiver = new ClassName(element.asType());
                    break;
                }
                switch (element.getKind()) {
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case EXCEPTION_PARAMETER: 
                    case PARAMETER: {
                        receiver = new LocalVariable(element);
                        break block0;
                    }
                    case FIELD: {
                        TypeMirror enclosingType = ElementUtils.enclosingClass((Element)element).asType();
                        Receiver fieldAccessExpression = ElementUtils.isStatic((Element)element) ? new ClassName(enclosingType) : new ThisReference(enclosingType);
                        receiver = new FieldAccess(fieldAccessExpression, typeOfId, (VariableElement)element);
                        break block0;
                    }
                }
                receiver = null;
                break;
            }
            case UNARY_PLUS: {
                return FlowExpressions.internalReprOf(provider, ((UnaryTree)receiverTree).getExpression(), allowNonDeterministic);
            }
            default: {
                receiver = null;
            }
        }
        if (receiver == null) {
            receiver = new Unknown(TreeUtils.typeOf((Tree)receiverTree));
        }
        return receiver;
    }

    public static Receiver internalReprOfImplicitReceiver(Element ele) {
        TypeElement enclosingClass = ElementUtils.enclosingClass((Element)ele);
        if (enclosingClass == null) {
            throw new BugInCF("internalReprOfImplicitReceiver's arg has no enclosing class: " + ele);
        }
        TypeMirror enclosingType = enclosingClass.asType();
        if (ElementUtils.isStatic((Element)ele)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    public static Receiver internalReprOfPseudoReceiver(TreePath path, TypeMirror enclosingType) {
        if (TreeUtils.isTreeInStaticScope((TreePath)path)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    private static Receiver internalReprOfMemberSelect(AnnotationProvider provider, MemberSelectTree memberSelectTree) {
        TypeMirror expressionType = TreeUtils.typeOf((Tree)memberSelectTree.getExpression());
        if (TreeUtils.isClassLiteral((Tree)memberSelectTree)) {
            return new ClassName(expressionType);
        }
        assert (TreeUtils.isUseOfElement((ExpressionTree)memberSelectTree)) : "@AssumeAssertion(nullness): tree kind";
        Element ele = TreeUtils.elementFromUse((ExpressionTree)memberSelectTree);
        if (ElementUtils.isClassElement((Element)ele)) {
            TypeMirror selectType = TreeUtils.typeOf((Tree)memberSelectTree);
            return new ClassName(selectType);
        }
        switch (ele.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return FlowExpressions.internalReprOf(provider, memberSelectTree.getExpression());
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror fieldType = TreeUtils.typeOf((Tree)memberSelectTree);
                Receiver r = FlowExpressions.internalReprOf(provider, memberSelectTree.getExpression());
                return new FieldAccess(r, fieldType, (VariableElement)ele);
            }
        }
        throw new BugInCF("Unexpected element kind: %s element: %s", new Object[]{ele.getKind(), ele});
    }

    public static @Nullable List<Receiver> getParametersOfEnclosingMethod(AnnotationProvider annotationProvider, TreePath path) {
        MethodTree methodTree = TreeUtils.enclosingMethod((TreePath)path);
        if (methodTree == null) {
            return null;
        }
        ArrayList<Receiver> internalArguments = new ArrayList<Receiver>();
        for (VariableTree variableTree : methodTree.getParameters()) {
            internalArguments.add(FlowExpressions.internalReprOf(annotationProvider, new LocalVariableNode(variableTree)));
        }
        return internalArguments;
    }

    public static class ArrayCreation
    extends Receiver {
        protected final List<? extends @Nullable Receiver> dimensions;
        protected final List<Receiver> initializers;

        public ArrayCreation(TypeMirror type, List<? extends @Nullable Receiver> dimensions, List<Receiver> initializers) {
            super(type);
            this.dimensions = dimensions;
            this.initializers = initializers;
        }

        public List<? extends @Nullable Receiver> getDimensions() {
            return this.dimensions;
        }

        public List<Receiver> getInitializers() {
            return this.initializers;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            for (Receiver receiver : this.dimensions) {
                if (receiver == null || receiver.getClass() != clazz) continue;
                return true;
            }
            for (Receiver receiver : this.initializers) {
                if (receiver.getClass() != clazz) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return false;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.dimensions, this.initializers, this.getType().toString());
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ArrayCreation)) {
                return false;
            }
            ArrayCreation other = (ArrayCreation)obj;
            return this.dimensions.equals(other.getDimensions()) && this.initializers.equals(other.getInitializers()) && this.getType().toString().equals(other.getType().toString());
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return this.equals(other);
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("new " + this.type);
            if (!this.dimensions.isEmpty()) {
                for (Receiver receiver : this.dimensions) {
                    sb.append("[");
                    sb.append(receiver == null ? "" : receiver);
                    sb.append("]");
                }
            }
            if (!this.initializers.isEmpty()) {
                boolean needComma = false;
                sb.append(" {");
                for (Receiver init : this.initializers) {
                    if (needComma) {
                        sb.append(", ");
                    }
                    sb.append(init);
                    needComma = true;
                }
                sb.append("}");
            }
            return sb.toString();
        }
    }

    public static class ArrayAccess
    extends Receiver {
        protected final Receiver receiver;
        protected final Receiver index;

        public ArrayAccess(TypeMirror type, Receiver receiver, Receiver index) {
            super(type);
            this.receiver = receiver;
            this.index = index;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            if (this.getClass() == clazz) {
                return true;
            }
            if (this.receiver.containsOfClass(clazz)) {
                return true;
            }
            return this.index.containsOfClass(clazz);
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public Receiver getIndex() {
            return this.index;
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return false;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.syntacticEquals(other) || this.index.syntacticEquals(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess otherArrayAccess = (ArrayAccess)other;
            if (!this.receiver.syntacticEquals(otherArrayAccess.receiver)) {
                return false;
            }
            return this.index.syntacticEquals(otherArrayAccess.index);
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            if (this.receiver.containsModifiableAliasOf(store, other)) {
                return true;
            }
            return this.index.containsModifiableAliasOf(store, other);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)obj;
            return this.receiver.equals(other.receiver) && this.index.equals(other.index);
        }

        public int hashCode() {
            return Objects.hash(this.receiver, this.index);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.receiver.toString());
            result.append("[");
            result.append(this.index.toString());
            result.append("]");
            return result.toString();
        }
    }

    public static class BinaryOperation
    extends Receiver {
        protected final Tree.Kind operationKind;
        protected final JCTree.Tag tag;
        protected final Receiver left;
        protected final Receiver right;

        public BinaryOperation(BinaryOperationNode node, Receiver left, Receiver right) {
            super(node.getType());
            this.operationKind = node.getTree().getKind();
            this.tag = ((JCTree)((Object)node.getTree())).getTag();
            this.left = left;
            this.right = right;
        }

        public Tree.Kind getOperationKind() {
            return this.operationKind;
        }

        public Receiver getLeft() {
            return this.left;
        }

        public Receiver getRight() {
            return this.right;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            if (this.getClass() == clazz) {
                return true;
            }
            return this.left.containsOfClass(clazz) || this.right.containsOfClass(clazz);
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return this.left.isUnassignableByOtherCode() && this.right.isUnassignableByOtherCode();
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return this.left.isUnmodifiableByOtherCode() && this.right.isUnmodifiableByOtherCode();
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof BinaryOperation)) {
                return false;
            }
            BinaryOperation biOp = (BinaryOperation)other;
            if (this.operationKind != biOp.getOperationKind()) {
                return false;
            }
            return this.left.equals(biOp.left) && this.right.equals(biOp.right);
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return this.left.containsModifiableAliasOf(store, other) || this.right.containsModifiableAliasOf(store, other);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.operationKind, this.left, this.right});
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof BinaryOperation)) {
                return false;
            }
            BinaryOperation biOp = (BinaryOperation)other;
            if (this.operationKind != biOp.getOperationKind()) {
                return false;
            }
            if (this.isCommutative()) {
                return this.left.equals(biOp.left) && this.right.equals(biOp.right) || this.left.equals(biOp.right) && this.right.equals(biOp.left);
            }
            return this.left.equals(biOp.left) && this.right.equals(biOp.right);
        }

        private boolean isCommutative() {
            switch (this.operationKind) {
                case PLUS: 
                case MULTIPLY: 
                case AND: 
                case OR: 
                case XOR: 
                case EQUAL_TO: 
                case NOT_EQUAL_TO: 
                case CONDITIONAL_AND: 
                case CONDITIONAL_OR: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            Pretty pretty = new Pretty(null, true);
            StringBuilder result = new StringBuilder();
            result.append(this.left.toString());
            result.append(pretty.operatorName(this.tag));
            result.append(this.right.toString());
            return result.toString();
        }
    }

    public static class MethodCall
    extends Receiver {
        protected final Receiver receiver;
        protected final List<Receiver> parameters;
        protected final ExecutableElement method;

        public MethodCall(TypeMirror type, ExecutableElement method, Receiver receiver, List<Receiver> parameters) {
            super(type);
            this.receiver = receiver;
            this.parameters = parameters;
            this.method = method;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            if (this.getClass() == clazz) {
                return true;
            }
            if (this.receiver.containsOfClass(clazz)) {
                return true;
            }
            for (Receiver p : this.parameters) {
                if (!p.containsOfClass(clazz)) continue;
                return true;
            }
            return false;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public List<Receiver> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }

        public ExecutableElement getElement() {
            return this.method;
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return this.receiver.isUnmodifiableByOtherCode() && this.parameters.stream().allMatch(Receiver::isUnmodifiableByOtherCode);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return this.isUnassignableByOtherCode();
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.syntacticEquals(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof MethodCall)) {
                return false;
            }
            MethodCall otherMethod = (MethodCall)other;
            if (!this.receiver.syntacticEquals(otherMethod.receiver)) {
                return false;
            }
            if (this.parameters.size() != otherMethod.parameters.size()) {
                return false;
            }
            int i = 0;
            for (Receiver p : this.parameters) {
                if (!p.syntacticEquals(otherMethod.parameters.get(i))) {
                    return false;
                }
                ++i;
            }
            return this.method.equals(otherMethod.method);
        }

        public boolean containsSyntacticEqualParameter(LocalVariable var) {
            for (Receiver p : this.parameters) {
                if (!p.containsSyntacticEqualReceiver(var)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            if (this.receiver.containsModifiableAliasOf(store, other)) {
                return true;
            }
            for (Receiver p : this.parameters) {
                if (!p.containsModifiableAliasOf(store, other)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MethodCall)) {
                return false;
            }
            if (this.method.getKind() == ElementKind.CONSTRUCTOR) {
                return false;
            }
            MethodCall other = (MethodCall)obj;
            return this.parameters.equals(other.parameters) && this.receiver.equals(other.receiver) && this.method.equals(other.method);
        }

        public int hashCode() {
            if (this.method.getKind() == ElementKind.CONSTRUCTOR) {
                return super.hashCode();
            }
            return Objects.hash(this.method, this.receiver, this.parameters);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.receiver instanceof ClassName) {
                result.append(this.receiver.getType());
            } else {
                result.append(this.receiver);
            }
            result.append(".");
            String methodName = this.method.getSimpleName().toString();
            result.append(methodName);
            result.append("(");
            boolean first = true;
            for (Receiver p : this.parameters) {
                if (!first) {
                    result.append(", ");
                }
                result.append(p.toString());
                first = false;
            }
            result.append(")");
            return result.toString();
        }
    }

    public static class ValueLiteral
    extends Receiver {
        protected final @Nullable Object value;

        public ValueLiteral(TypeMirror type, ValueLiteralNode node) {
            super(type);
            this.value = node.getValue();
        }

        public ValueLiteral(TypeMirror type, Object value) {
            super(type);
            this.value = value;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass() == clazz;
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return true;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ValueLiteral)) {
                return false;
            }
            ValueLiteral other = (ValueLiteral)obj;
            return this.type.toString().equals(other.type.toString()) && Objects.equals(this.value, other.value);
        }

        public String toString() {
            if (TypesUtils.isString((TypeMirror)this.type)) {
                return "\"" + this.value + "\"";
            }
            if (this.type.getKind() == TypeKind.LONG) {
                assert (this.value != null) : "@AssumeAssertion(nullness): invariant";
                return this.value.toString() + "L";
            }
            if (this.type.getKind() == TypeKind.CHAR) {
                return "'" + this.value + "'";
            }
            return this.value == null ? "null" : this.value.toString();
        }

        public int hashCode() {
            return Objects.hash(this.value, this.type.toString());
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return this.equals(other);
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }

        public @Nullable Object getValue() {
            return this.value;
        }
    }

    public static class LocalVariable
    extends Receiver {
        protected final Element element;

        public LocalVariable(LocalVariableNode localVar) {
            super(localVar.getType());
            this.element = localVar.getElement();
        }

        public LocalVariable(Element elem) {
            super(ElementUtils.getType((Element)elem));
            this.element = elem;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof LocalVariable)) {
                return false;
            }
            LocalVariable other = (LocalVariable)obj;
            Symbol.VarSymbol vs = (Symbol.VarSymbol)this.element;
            Symbol.VarSymbol vsother = (Symbol.VarSymbol)other.element;
            return vs.pos == vsother.pos && vsother.name.contentEquals(vs.name) && vsother.owner.toString().equals(vs.owner.toString());
        }

        public Element getElement() {
            return this.element;
        }

        public int hashCode() {
            Symbol.VarSymbol vs = (Symbol.VarSymbol)this.element;
            return Objects.hash(vs.name.toString(), TypeAnnotationUtils.unannotatedType((TypeMirror)vs.type).toString(), vs.owner.toString());
        }

        public String toString() {
            return this.element.toString();
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass() == clazz;
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof LocalVariable)) {
                return false;
            }
            LocalVariable l = (LocalVariable)other;
            return l.equals(this);
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other);
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return true;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return TypesUtils.isImmutableTypeInJdk((TypeMirror)((Symbol.VarSymbol)this.element).type);
        }
    }

    @UsesObjectEquals
    public static class Unknown
    extends Receiver {
        public Unknown(TypeMirror type) {
            super(type);
        }

        public boolean equals(@Nullable Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            return "?";
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return true;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass() == clazz;
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return false;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }
    }

    public static class ClassName
    extends Receiver {
        private final String typeString;

        public ClassName(TypeMirror type) {
            super(type);
            this.typeString = type.toString();
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ClassName)) {
                return false;
            }
            ClassName other = (ClassName)obj;
            return this.typeString.equals(other.typeString);
        }

        public int hashCode() {
            return Objects.hash(this.typeString);
        }

        public String toString() {
            return this.typeString + ".class";
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass() == clazz;
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return this.equals(other);
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return true;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }
    }

    public static class ThisReference
    extends Receiver {
        public ThisReference(TypeMirror type) {
            super(type);
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof ThisReference;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "this";
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass() == clazz;
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return other instanceof ThisReference;
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return true;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return TypesUtils.isImmutableTypeInJdk((TypeMirror)this.type);
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }
    }

    public static class FieldAccess
    extends Receiver {
        protected final Receiver receiver;
        protected final VariableElement field;

        public Receiver getReceiver() {
            return this.receiver;
        }

        public VariableElement getField() {
            return this.field;
        }

        public FieldAccess(Receiver receiver, FieldAccessNode node) {
            super(node.getType());
            this.receiver = receiver;
            this.field = node.getElement();
        }

        public FieldAccess(Receiver receiver, TypeMirror type, VariableElement fieldElement) {
            super(type);
            this.receiver = receiver;
            this.field = fieldElement;
        }

        public boolean isFinal() {
            return ElementUtils.isFinal((Element)this.field);
        }

        public boolean isStatic() {
            return ElementUtils.isStatic((Element)this.field);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof FieldAccess)) {
                return false;
            }
            FieldAccess fa = (FieldAccess)obj;
            return fa.getField().equals(this.getField()) && fa.getReceiver().equals(this.getReceiver());
        }

        public int hashCode() {
            return Objects.hash(this.getField(), this.getReceiver());
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return super.containsModifiableAliasOf(store, other) || this.receiver.containsModifiableAliasOf(store, other);
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.containsSyntacticEqualReceiver(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof FieldAccess)) {
                return false;
            }
            FieldAccess fa = (FieldAccess)other;
            return super.syntacticEquals(other) || fa.getField().equals(this.getField()) && fa.getReceiver().syntacticEquals(this.getReceiver());
        }

        public String toString() {
            if (this.receiver instanceof ClassName) {
                return this.receiver.getType() + "." + this.field;
            }
            return this.receiver + "." + this.field;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass() == clazz || this.receiver.containsOfClass(clazz);
        }

        @Override
        public boolean isUnassignableByOtherCode() {
            return this.isFinal() && this.getReceiver().isUnassignableByOtherCode();
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return this.isUnassignableByOtherCode() && TypesUtils.isImmutableTypeInJdk((TypeMirror)this.getReceiver().type);
        }
    }

    public static abstract class Receiver {
        protected final TypeMirror type;

        protected Receiver(TypeMirror type) {
            assert (type != null);
            this.type = type;
        }

        public TypeMirror getType() {
            return this.type;
        }

        public abstract boolean containsOfClass(Class<? extends Receiver> var1);

        public boolean containsUnknown() {
            return this.containsOfClass(Unknown.class);
        }

        public abstract boolean isUnassignableByOtherCode();

        public abstract boolean isUnmodifiableByOtherCode();

        @EqualsMethod
        public boolean syntacticEquals(Receiver other) {
            return other == this;
        }

        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other);
        }

        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return this.equals(other) || store.canAlias(this, other);
        }

        public String debugToString() {
            return String.format("Receiver (%s) %s type=%s", this.getClass().getSimpleName(), this.toString(), this.type);
        }
    }
}

