/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class WideningConversionNode
extends Node {
    protected Tree tree;
    protected Node operand;

    public WideningConversionNode(Tree tree, Node operand, TypeMirror type) {
        super(type);
        assert (TypesUtils.isPrimitive((TypeMirror)type)) : "non-primitive type in widening conversion";
        this.tree = tree;
        this.operand = operand;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public TypeMirror getType() {
        return this.type;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitWideningConversion(this, p);
    }

    public String toString() {
        return "WideningConversion(" + this.getOperand() + ", " + this.type + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WideningConversionNode)) {
            return false;
        }
        WideningConversionNode other = (WideningConversionNode)obj;
        return this.getOperand().equals(other.getOperand()) && TypesUtils.areSamePrimitiveTypes((TypeMirror)this.getType(), (TypeMirror)other.getType());
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

