/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.core.timing.TimerStructure;
import org.cache2k.core.timing.TimerTask;

public class TimerWheels
implements TimerStructure {
    private final Wheel wheel;

    public TimerWheels(long startTime, long delta, int slots) {
        this.wheel = new Wheel(startTime, delta, slots);
    }

    @Override
    public boolean schedule(TimerTask task, long time) {
        task.time = time;
        return this.wheel.schedule(task);
    }

    @Override
    public void cancelAll() {
        this.wheel.cancel();
    }

    @Override
    public TimerTask removeNextToRun(long time) {
        TimerTask t = this.wheel.removeNextToRun(time);
        return t;
    }

    @Override
    public long nextRun() {
        return this.wheel.nextToRun();
    }

    static class Wheel {
        private Wheel up;
        private long noon;
        private long nextNoon;
        private final long delta;
        private final TimerTask[] slots;
        private int index;

        Wheel(long time, long delta, int slotCount) {
            this.delta = delta;
            this.slots = new TimerTask[slotCount];
            this.initArray();
            this.atNoon(time);
        }

        private void initArray() {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = new TimerTask.Sentinel();
            }
        }

        private void atNoon(long time) {
            this.index = 0;
            this.noon = time;
            this.nextNoon = time + this.delta * (long)this.slots.length;
            if (this.nextNoon < 0L) {
                this.nextNoon = Long.MAX_VALUE;
            }
        }

        private void cancel() {
            this.up = null;
            this.initArray();
        }

        long executionTime(int i) {
            return this.noon + this.delta * (long)i + this.delta - 1L;
        }

        long nextToRun() {
            for (int i = this.index; i < this.slots.length; ++i) {
                if (!this.slots[i].isOccupied()) continue;
                return this.executionTime(i);
            }
            if (this.up == null) {
                return Long.MAX_VALUE;
            }
            return this.executionTime(this.slots.length);
        }

        public TimerTask removeNextToRun(long time) {
            long hand = this.executionTime(this.index);
            if (time >= hand) {
                while (true) {
                    TimerTask head;
                    if ((head = this.slots[this.index]).isOccupied()) {
                        TimerTask t = head.next;
                        t.remove();
                        return t;
                    }
                    if (time < (hand += this.delta)) break;
                    this.moveHand();
                }
            }
            return null;
        }

        private void moveHand() {
            ++this.index;
            if (this.index >= this.slots.length) {
                this.atNoon(this.nextNoon);
                this.refill();
            }
        }

        private void refill() {
            TimerTask t;
            long limit = this.nextNoon - 1L;
            Wheel up = this.up;
            if (up == null) {
                return;
            }
            while ((t = up.removeNextToRun(limit)) != null) {
                this.insert(t);
            }
        }

        private boolean schedule(TimerTask t) {
            long hand = this.executionTime(this.index - 1);
            if (t.time <= hand) {
                return false;
            }
            if (t.time < this.nextNoon) {
                this.insert(t);
                return true;
            }
            if (this.up == null) {
                this.up = new Wheel(this.nextNoon, this.delta * (long)this.slots.length, this.slots.length);
            }
            return this.up.schedule(t);
        }

        private void insert(TimerTask t) {
            int idx = (int)((t.time - this.noon) / this.delta);
            this.slots[idx].insert(t);
        }
    }
}

