/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.time.Instant;
import org.cache2k.core.util.Util;
import org.cache2k.io.CacheLoaderException;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.io.LoadExceptionInfo;

public final class DefaultExceptionPropagator<K, V>
implements ExceptionPropagator<K, V> {
    public static final DefaultExceptionPropagator<Object, Object> SINGLETON = new DefaultExceptionPropagator();

    private DefaultExceptionPropagator() {
    }

    public RuntimeException propagateException(LoadExceptionInfo<K, V> loadExceptionInfo) {
        long expiry = loadExceptionInfo.getUntil();
        String txt = "";
        if (expiry > 0L) {
            if (expiry == Long.MAX_VALUE) {
                txt = "expiry=ETERNAL, cause: ";
            } else {
                Instant t = Instant.ofEpochMilli(expiry);
                txt = "expiry=" + Util.formatTime(t) + ", cause: ";
            }
        }
        return new CacheLoaderException(txt + loadExceptionInfo.getException(), loadExceptionInfo.getException());
    }
}

