/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.cache2k.config.CacheBuildContext;
import org.cache2k.config.CustomizationSupplier;
import org.cache2k.core.CacheClosedException;
import org.cache2k.operation.Scheduler;

public class DefaultSchedulerProvider
implements CustomizationSupplier<Scheduler> {
    private static final int THREAD_COUNT = 2;
    private static final String THREAD_PREFIX = "cache2k-scheduler";
    public static final DefaultSchedulerProvider INSTANCE = new DefaultSchedulerProvider();
    private ScheduledExecutorService scheduledExecutor = null;
    private int usageCounter = 0;

    DefaultSchedulerProvider() {
    }

    public synchronized Scheduler supply(CacheBuildContext<?, ?> buildContext) {
        if (this.usageCounter == 0) {
            this.scheduledExecutor = new ScheduledThreadPoolExecutor(2, new DaemonThreadFactory());
        }
        ++this.usageCounter;
        return new MyScheduler(buildContext.getExecutor());
    }

    synchronized void cacheClientClosed() {
        if (--this.usageCounter == 0) {
            this.scheduledExecutor.shutdownNow();
            try {
                this.scheduledExecutor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(DefaultSchedulerProvider.THREAD_PREFIX);
            t.setPriority(10);
            return t;
        }
    }

    private class MyScheduler
    implements Scheduler,
    AutoCloseable {
        private final Executor executor;
        private boolean closed;

        private MyScheduler(Executor executor) {
            this.executor = executor;
        }

        public void schedule(Runnable task, long millis) {
            Runnable wrap = () -> this.executor.execute(task);
            long delay = millis - System.currentTimeMillis();
            delay = Math.max(0L, delay);
            try {
                DefaultSchedulerProvider.this.scheduledExecutor.schedule(wrap, delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException ex) {
                throw new CacheClosedException();
            }
        }

        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        @Override
        public synchronized void close() {
            if (!this.closed) {
                DefaultSchedulerProvider.this.cacheClientClosed();
                this.closed = true;
            }
        }
    }
}

