/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.eviction;

import org.cache2k.core.Entry;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.eviction.AbstractEviction;
import org.cache2k.core.eviction.HeapCacheForEviction;
import org.cache2k.core.eviction.InternalEvictionListener;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;
import org.cache2k.operation.Weigher;

public class ClockProPlusEviction
extends AbstractEviction {
    private long hotHits;
    private long coldHits;
    private long ghostHits;
    private long hotRunCnt;
    private long hotScanCnt;
    private long coldRunCnt;
    private long coldScanCnt;
    private int coldSize = 0;
    private int hotSize = 0;
    private Entry handCold = null;
    private Entry handHot = null;
    private Ghost[] ghosts;
    private final Ghost ghostHead = new Ghost().shortCircuit();
    private int ghostSize = 0;
    private long hotMax = Long.MAX_VALUE;
    private long ghostMax = Long.MAX_VALUE;
    private static final int GHOST_LOAD_PERCENT;
    private static final int HOT_MAX_PERCENTAGE;
    private static final int HIT_COUNTER_DECREASE_SHIFT;
    private static final int GHOST_MAX_PERCENTAGE;

    public ClockProPlusEviction(HeapCacheForEviction heapCache, InternalEvictionListener listener, long maxSize, Weigher weigher, long maxWeight, boolean noChunking) {
        super(heapCache, listener, maxSize, weigher, maxWeight, noChunking);
        this.ghosts = new Ghost[4];
    }

    private long sumUpListHits(Entry e) {
        if (e == null) {
            return 0L;
        }
        long cnt = 0L;
        Entry head = e;
        do {
            cnt += e.hitCnt;
        } while ((e = e.next) != head);
        return cnt;
    }

    public long getHotMax() {
        return this.hotMax;
    }

    public long getGhostMax() {
        return this.ghostMax;
    }

    @Override
    protected void updateHotMax() {
        this.hotMax = this.getSize() * (long)HOT_MAX_PERCENTAGE / 100L;
        this.ghostMax = this.getSize() * (long)GHOST_MAX_PERCENTAGE / 100L + 1L;
        this.ghostMax = Math.min(3000L, this.ghostMax);
        this.trimGhostSize();
    }

    @Override
    protected long removeAllFromReplacementList() {
        Entry next;
        Entry head;
        int count = 0;
        Entry e = head = this.handCold;
        long hits = 0L;
        if (e != null) {
            do {
                hits += e.hitCnt;
                next = e.prev;
                e.removedFromList();
                ++count;
            } while ((e = next) != head);
            this.coldHits += hits;
        }
        this.handCold = null;
        this.coldSize = 0;
        head = this.handHot;
        e = head;
        if (e != null) {
            hits = 0L;
            do {
                hits += e.hitCnt;
                next = e.prev;
                e.removedFromList();
                ++count;
            } while ((e = next) != head);
            this.hotHits += hits;
        }
        this.handHot = null;
        this.hotSize = 0;
        return count;
    }

    @Override
    public void removeFromReplacementListOnEvict(Entry e) {
        this.insertCopyIntoGhosts(e);
        this.removeFromReplacementList(e);
    }

    @Override
    protected void removeFromReplacementList(Entry e) {
        if (e.isHot()) {
            this.hotHits += e.hitCnt;
            this.handHot = Entry.removeFromCyclicList(this.handHot, e);
            --this.hotSize;
        } else {
            this.coldHits += e.hitCnt;
            this.handCold = Entry.removeFromCyclicList(this.handCold, e);
            --this.coldSize;
        }
    }

    private void insertCopyIntoGhosts(Entry e) {
        int hc = e.hashCode;
        Ghost g = this.lookupGhost(hc);
        if (g != null) {
            Ghost.moveToFront(this.ghostHead, g);
            return;
        }
        g = this.trimGhostSize();
        if (g == null) {
            g = new Ghost();
        }
        g.hash = hc;
        this.insertGhost(g, hc);
        Ghost.insertInList(this.ghostHead, g);
    }

    private Ghost trimGhostSize() {
        Ghost g = null;
        while ((long)this.ghostSize >= this.getGhostMax()) {
            g = this.ghostHead.prev;
            Ghost.removeFromList(g);
            boolean bl = this.removeGhost(g, g.hash);
        }
        return g;
    }

    @Override
    public long getSize() {
        return this.hotSize + this.coldSize;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        Ghost g = this.lookupGhost(e.hashCode);
        if (g != null) {
            ++this.ghostHits;
        }
        if (g != null || this.coldSize == 0 && (long)this.hotSize < this.getHotMax()) {
            e.setHot(true);
            ++this.hotSize;
            this.handHot = Entry.insertIntoTailCyclicList(this.handHot, e);
            return;
        }
        ++this.coldSize;
        this.handCold = Entry.insertIntoTailCyclicList(this.handCold, e);
    }

    private Entry runHandHot() {
        int initialMaxScan;
        Entry hand;
        ++this.hotRunCnt;
        Entry coldCandidate = hand = this.handHot;
        long lowestHits = Long.MAX_VALUE;
        long hotHits = this.hotHits;
        int maxScan = initialMaxScan = (this.hotSize >> 2) + 1;
        long decrease = (hand.hitCnt + hand.next.hitCnt >> HIT_COUNTER_DECREASE_SHIFT) + 1L;
        while (maxScan-- > 0) {
            long hitCnt = hand.hitCnt;
            if (hitCnt < lowestHits) {
                lowestHits = hitCnt;
                coldCandidate = hand;
                if (hitCnt == 0L) {
                    hand = hand.next;
                    break;
                }
            }
            if (hitCnt < decrease) {
                hand.hitCnt = 0L;
                hotHits += hitCnt;
            } else {
                hand.hitCnt = hitCnt - decrease;
                hotHits += decrease;
            }
            hand = hand.next;
        }
        this.hotHits = hotHits;
        long scanCount = initialMaxScan - maxScan;
        this.hotScanCnt += scanCount;
        this.handHot = hand;
        return coldCandidate;
    }

    @Override
    protected Entry findEvictionCandidate() {
        Entry hand = this.handCold;
        if ((long)this.hotSize > this.getHotMax() || hand == null) {
            return this.runHandHot();
        }
        ++this.coldRunCnt;
        int scanCnt = 1;
        if (hand.hitCnt > 0L) {
            Entry evictFromHot = null;
            do {
                if ((long)this.hotSize >= this.getHotMax() && this.handHot != null) {
                    evictFromHot = this.runHandHot();
                }
                this.coldHits += hand.hitCnt;
                Entry e = hand;
                hand = Entry.removeFromCyclicList(e);
                --this.coldSize;
                e.setHot(true);
                e.hitCnt = 0L;
                ++this.hotSize;
                this.handHot = Entry.insertIntoTailCyclicList(this.handHot, e);
                if (evictFromHot != null) {
                    this.coldScanCnt += (long)scanCnt;
                    this.handCold = hand;
                    return evictFromHot;
                }
                ++scanCnt;
            } while (hand != null && hand.hitCnt > 0L);
        }
        this.coldScanCnt += (long)scanCnt;
        if (hand == null) {
            this.handCold = null;
            return this.runHandHot();
        }
        this.handCold = hand.next;
        return hand;
    }

    @Override
    public void checkIntegrity(IntegrityState integrityState) {
        integrityState.checkEquals("ghostSize == countGhostsInHash()", this.ghostSize, this.countGhostsInHash()).check("checkCyclicListIntegrity(handHot)", Entry.checkCyclicListIntegrity(this.handHot)).check("checkCyclicListIntegrity(handCold)", Entry.checkCyclicListIntegrity(this.handCold)).checkEquals("getCyclicListEntryCount(handHot) == hotSize", Entry.getCyclicListEntryCount(this.handHot), this.hotSize).checkEquals("getCyclicListEntryCount(handCold) == coldSize", Entry.getCyclicListEntryCount(this.handCold), this.coldSize).checkEquals("Ghost.listSize(ghostHead) == ghostSize", Ghost.listSize(this.ghostHead), this.ghostSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return super.toString() + ", coldSize=" + this.coldSize + ", hotSize=" + this.hotSize + ", hotMaxSize=" + this.getHotMax() + ", ghostSize=" + this.ghostSize + ", ghostMaxSize=" + this.getGhostMax() + ", coldHits=" + (this.coldHits + this.sumUpListHits(this.handCold)) + ", hotHits=" + (this.hotHits + this.sumUpListHits(this.handHot)) + ", ghostHits=" + this.ghostHits + ", coldRunCnt=" + this.coldRunCnt + ", coldScanCnt=" + this.coldScanCnt + ", hotRunCnt=" + this.hotRunCnt + ", hotScanCnt=" + this.hotScanCnt;
        }
    }

    private Ghost lookupGhost(int hash) {
        Ghost[] tab = this.ghosts;
        int n = tab.length;
        int mask = n - 1;
        int idx = hash & mask;
        Ghost e = tab[idx];
        while (e != null) {
            if (e.hash == hash) {
                return e;
            }
            e = e.another;
        }
        return null;
    }

    private void insertGhost(Ghost e2, int hash) {
        Ghost[] tab = this.ghosts;
        int n = tab.length;
        int mask = n - 1;
        int idx = hash & mask;
        e2.another = tab[idx];
        tab[idx] = e2;
        ++this.ghostSize;
        int maxFill = n * GHOST_LOAD_PERCENT / 100;
        if (this.ghostSize > maxFill) {
            this.expand();
        }
    }

    private void expand() {
        Ghost[] tab = this.ghosts;
        int n = tab.length;
        Ghost[] newTab = new Ghost[n * 2];
        int mask = newTab.length - 1;
        for (Ghost g : tab) {
            while (g != null) {
                int idx = g.hash & mask;
                Ghost next = g.another;
                g.another = newTab[idx];
                newTab[idx] = g;
                g = next;
            }
        }
        this.ghosts = newTab;
    }

    private boolean removeGhost(Ghost g, int hash) {
        Ghost[] tab = this.ghosts;
        int n = tab.length;
        int mask = n - 1;
        int idx = hash & mask;
        Ghost e = tab[idx];
        if (e == g) {
            tab[idx] = e.another;
            --this.ghostSize;
            return true;
        }
        while (e != null) {
            Ghost another = e.another;
            if (another == g) {
                e.another = another.another;
                --this.ghostSize;
                return true;
            }
            e = another;
        }
        return false;
    }

    private int countGhostsInHash() {
        int entryCount = 0;
        for (Ghost e : this.ghosts) {
            while (e != null) {
                ++entryCount;
                e = e.another;
            }
        }
        return entryCount;
    }

    static {
        Tunable tunable = TunableFactory.get(Tunable.class);
        GHOST_LOAD_PERCENT = tunable.ghostLoadPercentage;
        HOT_MAX_PERCENTAGE = tunable.hotMaxPercentage;
        HIT_COUNTER_DECREASE_SHIFT = tunable.hitCounterDecreaseShift;
        GHOST_MAX_PERCENTAGE = tunable.ghostMaxPercentage;
    }

    public static class Tunable
    extends TunableConstants {
        public int hotMaxPercentage = 97;
        public int hitCounterDecreaseShift = 6;
        public int ghostLoadPercentage = 63;
        public int ghostMaxPercentage = 50;
    }

    private static class Ghost {
        int hash;
        Ghost another;
        Ghost next;
        Ghost prev;

        private Ghost() {
        }

        Ghost shortCircuit() {
            this.next = this.prev = this;
            return this.prev;
        }

        static void removeFromList(Ghost e) {
            e.prev.next = e.next;
            e.next.prev = e.prev;
            e.prev = null;
            e.next = null;
        }

        static void insertInList(Ghost head, Ghost e) {
            e.prev = head;
            e.next = head.next;
            e.next.prev = e;
            head.next = e;
        }

        static void moveToFront(Ghost head, Ghost e) {
            Ghost.removeFromList(e);
            Ghost.insertInList(head, e);
        }

        static int listSize(Ghost head) {
            int count = 0;
            Ghost e = head;
            while ((e = e.next) != head) {
                ++count;
            }
            return count;
        }
    }
}

