/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.config.CacheType;
import org.cache2k.core.BaseCache;
import org.cache2k.core.BulkAction;
import org.cache2k.core.BulkResultCollector;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CacheOperationInterruptedException;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.EntryProcessingResultFactory;
import org.cache2k.core.HeapCache;
import org.cache2k.core.OperationCompletion;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.eviction.Eviction;
import org.cache2k.core.eviction.InternalEvictionListener;
import org.cache2k.core.log.Log;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.timing.Timing;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryEvictedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncBulkCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.BulkCacheLoader;
import org.cache2k.io.CacheLoaderException;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.operation.TimeReference;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public class WiredCache<K, V>
extends BaseCache<K, V>
implements InternalEvictionListener<K, V> {
    final Operations<K, V> ops = Operations.SINGLETON;
    Cache<K, V> userCache;
    HeapCache<K, V> heapCache;
    AdvancedCacheLoader<K, V> loader;
    AsyncCacheLoader<K, V> asyncLoader;
    BulkCacheLoader<K, V> bulkCacheLoader;
    CacheWriter<K, V> writer;
    CacheEntryRemovedListener<K, V>[] syncEntryRemovedListeners;
    CacheEntryCreatedListener<K, V>[] syncEntryCreatedListeners;
    CacheEntryUpdatedListener<K, V>[] syncEntryUpdatedListeners;
    CacheEntryExpiredListener<K, V>[] syncEntryExpiredListeners;
    CacheEntryEvictedListener<K, V>[] syncEntryEvictedListeners;

    private CommonMetrics.Updater metrics() {
        return this.heapCache.metrics;
    }

    @Override
    public Log getLog() {
        return this.heapCache.getLog();
    }

    public HeapCache getHeapCache() {
        return this.heapCache;
    }

    @Override
    public TimeReference getClock() {
        return this.heapCache.getClock();
    }

    @Override
    public boolean isNullValuePermitted() {
        return this.heapCache.isNullValuePermitted();
    }

    @Override
    public String getName() {
        return this.heapCache.getName();
    }

    @Override
    public CacheType getKeyType() {
        return this.heapCache.getKeyType();
    }

    @Override
    public CacheType getValueType() {
        return this.heapCache.getValueType();
    }

    @Override
    public CacheManager getCacheManager() {
        return this.heapCache.getCacheManager();
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> function) {
        return this.returnValue(this.execute(key, this.ops.computeIfAbsent((K)key, function)));
    }

    public V peekAndPut(K key, V value) {
        return this.returnValue(this.execute(key, this.ops.peekAndPut(key, value)));
    }

    public V peekAndRemove(K key) {
        return this.returnValue(this.execute(key, this.ops.peekAndRemove(key)));
    }

    public V peekAndReplace(K key, V value) {
        return this.returnValue(this.execute(key, this.ops.peekAndReplace(key, value)));
    }

    public CacheEntry<K, V> peekEntry(K key) {
        return this.execute(key, this.ops.peekEntry());
    }

    public boolean containsKey(K key) {
        return this.execute(key, this.ops.contains(key));
    }

    public boolean putIfAbsent(K key, V value) {
        return this.execute(key, this.ops.putIfAbsent(key, value));
    }

    public void put(K key, V value) {
        this.execute(key, this.ops.put(key, value));
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void remove(K key) {
        this.execute(key, this.ops.remove(key));
    }

    public boolean removeIfEquals(K key, V value) {
        return this.execute(key, this.ops.remove(key, value));
    }

    public boolean containsAndRemove(K key) {
        return this.execute(key, this.ops.containsAndRemove(key));
    }

    public boolean replace(K key, V newValue) {
        return this.execute(key, this.ops.replace(key, newValue));
    }

    public boolean replaceIfEquals(K key, V oldValue, V newValue) {
        return this.execute(key, this.ops.replace(key, oldValue, newValue));
    }

    public CompletableFuture<Void> loadAll(Iterable<? extends K> keys) {
        this.checkLoaderPresent();
        BulkResultCollector collect = new BulkResultCollector();
        Set<K> keysToLoad = this.getAllPrescreen(keys, collect);
        CacheLoaderException prescreenException = collect.getAnyLoaderException();
        if (keysToLoad.isEmpty()) {
            if (prescreenException != null) {
                CompletableFuture<Void> f = new CompletableFuture<Void>();
                f.completeExceptionally((Throwable)prescreenException);
                return f;
            }
            return CompletableFuture.completedFuture(null);
        }
        if (this.asyncLoader != null) {
            return this.failAnyway(prescreenException, this.completeWithVoid(this.asyncBulkOp(Operations.GET, keysToLoad, true)));
        }
        if (this.bulkCacheLoader == null) {
            return this.failAnyway(prescreenException, this.loadAllWithSyncLoader(keysToLoad));
        }
        return this.failAnyway(prescreenException, this.executeSyncBulkOp(Operations.GET, keysToLoad, true));
    }

    private CompletableFuture<Void> failAnyway(CacheLoaderException ex, CompletableFuture<Void> f) {
        if (ex != null) {
            CompletableFuture<Void> other = new CompletableFuture<Void>();
            f.handle((unused, throwable) -> {
                other.completeExceptionally((Throwable)ex);
                return null;
            });
            return other;
        }
        return f;
    }

    private CompletableFuture<Void> executeSyncBulkOp(Semantic operation, Set<K> keys, boolean propagateLoadException) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Runnable runnable = () -> {
            Throwable t;
            try {
                BulkAction result = this.syncBulkOp(operation, keys);
                t = result.getExceptionToPropagate();
                if (propagateLoadException && t == null) {
                    t = result.getLoaderException();
                }
            }
            catch (Throwable maybeCacheClosedException) {
                t = maybeCacheClosedException;
            }
            if (t != null) {
                future.completeExceptionally(t);
            } else {
                future.complete(null);
            }
        };
        this.heapCache.executeLoader(runnable);
        return future;
    }

    private <R> BulkAction<K, V, R> syncBulkOp(final Semantic<K, V, R> op, Set<K> keys) {
        AsyncBulkCacheLoader myLoader = (keySet, contexts, callback) -> {
            try {
                callback.onLoadSuccess(this.bulkCacheLoader.loadAll(keySet));
            }
            catch (Throwable ouch) {
                callback.onLoadFailure(ouch);
            }
        };
        BulkAction bulkAction = new BulkAction<K, V, R>(this.heapCache, this, (AsyncCacheLoader)myLoader, keys){

            @Override
            protected boolean isSyncMode() {
                return true;
            }

            @Override
            protected EntryAction<K, V, R> createEntryAction(K key, final BulkAction<K, V, R> bulkAction) {
                return new MyEntryAction<R>(op, key, null, null){

                    @Override
                    protected AsyncCacheLoader<K, V> asyncLoader() {
                        return bulkAction;
                    }
                };
            }
        };
        bulkAction.start();
        return bulkAction;
    }

    private <R> CompletableFuture<BulkAction<K, V, R>> asyncBulkOp(final Semantic<K, V, R> op, Set<K> keys, final boolean completeExceptionally) {
        final CompletableFuture<BulkAction<K, V, R>> future = new CompletableFuture<BulkAction<K, V, R>>();
        BulkAction action = new BulkAction<K, V, R>(this.heapCache, this, this.asyncLoader, keys){

            @Override
            protected EntryAction<K, V, R> createEntryAction(K key, final BulkAction<K, V, R> bulkAction) {
                return new MyEntryAction<R>(op, key, null, bulkAction){

                    @Override
                    protected AsyncCacheLoader<K, V> asyncLoader() {
                        return bulkAction;
                    }
                };
            }

            @Override
            protected void bulkOperationCompleted() {
                Throwable exception;
                Throwable throwable = exception = completeExceptionally ? this.getException() : null;
                if (exception != null) {
                    future.completeExceptionally(exception);
                } else {
                    future.complete(this);
                }
            }
        };
        action.start();
        return future;
    }

    private CompletableFuture<Void> loadAllWithSyncLoader(Set<K> keysToLoad) {
        OperationCompletion<K> completion = new OperationCompletion<K>(keysToLoad);
        for (K key : keysToLoad) {
            this.heapCache.executeLoader(completion, key, () -> {
                EntryAction<Object, V, V> action = this.createEntryAction(key, null, this.ops.get(key));
                action.start();
                return action.getException();
            });
        }
        return completion.getFuture();
    }

    private CompletableFuture<Void> completeWithVoid(CompletableFuture<BulkAction<K, V, Void>> future) {
        return future.thenApply(action -> null);
    }

    public CompletableFuture<Void> reloadAll(Iterable<? extends K> keys) {
        this.checkLoaderPresent();
        Set<? extends K> keySet = HeapCache.generateKeySet(keys);
        if (this.asyncLoader != null) {
            return this.completeWithVoid(this.asyncBulkOp(this.ops.unconditionalLoad, keySet, true));
        }
        if (this.bulkCacheLoader == null) {
            return this.reloadAllWithSyncLoader(keySet);
        }
        return this.executeSyncBulkOp(this.ops.unconditionalLoad, keySet, true);
    }

    private CompletableFuture<Void> reloadAllWithSyncLoader(Set<K> keysToLoad) {
        OperationCompletion<K> completion = new OperationCompletion<K>(keysToLoad);
        for (K key : keysToLoad) {
            this.heapCache.executeLoader(completion, key, () -> {
                EntryAction action = this.createEntryAction(key, null, this.ops.unconditionalLoad);
                action.start();
                return action.getException();
            });
        }
        return completion.getFuture();
    }

    protected <R> MyEntryAction<R> createFireAndForgetAction(Entry<K, V> e, Semantic<K, V, R> op) {
        return new MyEntryAction<R>(op, e.getKey(), e, EntryAction.NOOP_CALLBACK);
    }

    @Override
    public Executor getExecutor() {
        return this.heapCache.getExecutor();
    }

    private void checkLoaderPresent() {
        if (!this.isLoaderPresent()) {
            throw new UnsupportedOperationException("loader not set");
        }
    }

    @Override
    public boolean isWeigherPresent() {
        return this.heapCache.eviction.isWeigherPresent();
    }

    @Override
    public boolean isLoaderPresent() {
        return this.loader != null || this.asyncLoader != null;
    }

    V returnValue(Object v) {
        return HeapCache.returnValue(v);
    }

    V returnValue(Entry<K, V> e) {
        return this.returnValue(e.getValueOrException());
    }

    Entry<K, V> lookupQuick(K key) {
        return this.heapCache.lookupEntry(key);
    }

    public V get(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData(this.getClock())) {
            return this.returnValue(e);
        }
        return this.returnValue(this.execute(key, e, this.ops.get(key)));
    }

    public Map<K, V> getAll(Iterable<? extends K> requestedKeys) {
        BulkResultCollector collect = new BulkResultCollector();
        Set<K> keysMissing = this.getAllPrescreen(requestedKeys, collect);
        if (!keysMissing.isEmpty()) {
            if (this.asyncLoader != null) {
                this.getAllAsyncLoad(collect, keysMissing);
            } else if (this.loader != null) {
                if (this.bulkCacheLoader == null) {
                    this.getAllConcurrentLoad(collect, keysMissing);
                } else {
                    this.getAllBulkLoad(collect, keysMissing);
                }
            }
        }
        return collect.mapOrThrowIfAllFaulty();
    }

    private void getAllBulkLoad(BulkResultCollector<K, V> collect, Set<K> keysMissing) {
        BulkAction bulkAction = this.syncBulkOp(Operations.GET, keysMissing);
        Throwable t = bulkAction.getExceptionToPropagate();
        if (t != null) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new CacheException(t);
        }
        collect.putAll(bulkAction.getActions());
    }

    private void getAllAsyncLoad(BulkResultCollector<K, V> collect, Set<K> keysMissing) {
        try {
            BulkAction bulkAction = this.asyncBulkOp(Operations.GET, keysMissing, true).get();
            collect.putAll(bulkAction.getActions());
        }
        catch (InterruptedException ex) {
            CacheOperationInterruptedException.propagate(ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof CacheLoaderException) {
                cause.fillInStackTrace();
                throw (CacheLoaderException)cause;
            }
            throw new CacheException(ex.getCause());
        }
    }

    private Set<K> getAllPrescreen(Iterable<? extends K> requestedKeys, BulkResultCollector<K, V> collect) {
        HashSet<K> missingKeys = new HashSet<K>();
        HashSet<K> processedKeys = new HashSet<K>();
        for (K key : requestedKeys) {
            if (processedKeys.contains(key)) continue;
            Entry<K, V> e = this.lookupQuick(key);
            if (e != null) {
                if (e.hasFreshData(this.getClock())) {
                    collect.put(key, e.getValueOrException());
                } else {
                    this.metrics().heapHitButNoRead();
                    missingKeys.add(key);
                }
            } else {
                missingKeys.add(key);
            }
            processedKeys.add(key);
        }
        return missingKeys;
    }

    private void getAllConcurrentLoad(BulkResultCollector<K, V> collect, Set<? extends K> keysMissing) {
        HashSet actions = new HashSet(keysMissing.size());
        CountDownLatch completion = new CountDownLatch(keysMissing.size());
        EntryAction.CompletedCallback cb = ea -> completion.countDown();
        for (K key : keysMissing) {
            MyEntryAction action = new MyEntryAction(Operations.GET, key, null, cb);
            actions.add(action);
            this.heapCache.executeLoader(action);
        }
        try {
            completion.await();
        }
        catch (InterruptedException ex) {
            CacheOperationInterruptedException.propagate(ex);
        }
        collect.putAll(actions);
    }

    public CacheEntry<K, V> getEntry(K key) {
        return this.execute(key, this.ops.getEntry(key));
    }

    @Override
    public long getTotalEntryCount() {
        return this.heapCache.getTotalEntryCount();
    }

    public <R> R invoke(K key, EntryProcessor<K, V, R> processor) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.execute(key, this.ops.invoke(processor));
    }

    @Override
    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> keys, EntryProcessor<K, V, R> entryProcessor) {
        if (this.bulkCacheLoader == null && this.asyncLoader == null) {
            return super.invokeAll(keys, entryProcessor);
        }
        Set<? extends K> keySet = HeapCache.generateKeySet(keys);
        if (this.asyncLoader != null) {
            return this.invokeAllAsyncLoader(entryProcessor, keySet);
        }
        BulkAction<K, V, R> actionResult = this.syncBulkOp(this.ops.invoke(entryProcessor), keySet);
        HashMap resultMap = new HashMap();
        for (EntryAction<K, V, R> action : actionResult.getActions()) {
            Throwable exception = action.getException();
            Object singleResult = exception == null ? EntryProcessingResultFactory.result(action.getResult()) : EntryProcessingResultFactory.exception(exception);
            resultMap.put(action.getKey(), singleResult);
        }
        return resultMap;
    }

    private <R> Map<K, EntryProcessingResult<R>> invokeAllAsyncLoader(EntryProcessor<K, V, R> entryProcessor, Set<K> keySet) {
        try {
            HashMap resultMap = new HashMap();
            BulkAction<K, V, R> bulkAction = this.asyncBulkOp(this.ops.invoke(entryProcessor), keySet, false).get();
            for (EntryAction<K, V, R> action : bulkAction.getActions()) {
                Throwable ex = action.getException();
                Object result = null;
                if (ex != null) {
                    result = EntryProcessingResultFactory.exception(ex);
                } else if (action.isResultAvailable()) {
                    result = EntryProcessingResultFactory.result(action.getResult());
                }
                if (result == null) continue;
                resultMap.put(action.getKey(), result);
            }
            return resultMap;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CacheOperationInterruptedException(ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof CacheLoaderException) {
                cause.fillInStackTrace();
                throw (CacheLoaderException)cause;
            }
            throw new CacheException(ex.getCause());
        }
    }

    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        final HeapCache.IteratorFilterEntry2Entry<K, V> it = new HeapCache.IteratorFilterEntry2Entry<K, V>(this.heapCache, this.heapCache.iterateAllHeapEntries(), true);
        Iterator adapted = new Iterator<CacheEntry<K, V>>(){
            CacheEntry<K, V> entry;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public CacheEntry<K, V> next() {
                this.entry = (CacheEntry)it.next();
                return this.entry;
            }

            @Override
            public void remove() {
                if (this.entry == null) {
                    throw new IllegalStateException("call to next() missing or double remove()");
                }
                WiredCache.this.remove(this.entry.getKey());
                this.entry = null;
            }
        };
        return adapted;
    }

    public V peek(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData(this.getClock())) {
            return this.returnValue(e);
        }
        return this.returnValue(this.execute(key, this.ops.peek(key)));
    }

    public Map<K, V> peekAll(Iterable<? extends K> keys) {
        HashMap<K, CacheEntry> map = new HashMap<K, CacheEntry>();
        for (K k : keys) {
            CacheEntry e = this.execute(k, this.ops.peekEntry());
            if (e == null) continue;
            map.put(k, e);
        }
        return this.heapCache.convertCacheEntry2ValueMap(map);
    }

    @Override
    public InternalCacheInfo getConsistentInfo() {
        return this.heapCache.getConsistentInfo(this);
    }

    @Override
    public InternalCacheInfo getInfo() {
        return this.heapCache.getInfo(this);
    }

    @Override
    public CommonMetrics getCommonMetrics() {
        return this.heapCache.getCommonMetrics();
    }

    @Override
    public void logAndCountInternalException(String s, Throwable t) {
        this.heapCache.logAndCountInternalException(s, t);
    }

    @Override
    public void checkIntegrity() {
        this.heapCache.checkIntegrity();
    }

    public boolean isClosed() {
        return this.heapCache.isClosed();
    }

    public void init() {
        this.heapCache.timing.setTarget(this);
        this.heapCache.initWithoutTimerHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTimerJobs() {
        Object object = this.lockObject();
        synchronized (object) {
            this.heapCache.cancelTimerJobs();
        }
    }

    public void clear() {
        this.heapCache.clear();
    }

    public void close() {
        try {
            this.heapCache.closePart1();
        }
        catch (CacheClosedException ex) {
            return;
        }
        this.heapCache.closePart2(this);
        this.closeCustomization(this.asyncLoader, "asyncLoader");
        this.closeCustomization(this.writer, "writer");
        if (this.syncEntryCreatedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryCreatedListeners) {
                this.closeCustomization(cacheEntryCreatedListener, "entryCreatedListener");
            }
        }
        if (this.syncEntryUpdatedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryUpdatedListeners) {
                this.closeCustomization(cacheEntryCreatedListener, "entryUpdatedListener");
            }
        }
        if (this.syncEntryRemovedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryRemovedListeners) {
                this.closeCustomization(cacheEntryCreatedListener, "entryRemovedListener");
            }
        }
        if (this.syncEntryExpiredListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryExpiredListeners) {
                this.closeCustomization(cacheEntryCreatedListener, "entryExpiredListener");
            }
        }
    }

    @Override
    public CacheEntry<K, V> returnCacheEntry(ExaminationEntry<K, V> e) {
        return this.heapCache.returnCacheEntry(e);
    }

    private Object lockObject() {
        return this.heapCache.lock;
    }

    @Override
    public Eviction getEviction() {
        return this.heapCache.getEviction();
    }

    @Override
    public void onEvictionFromHeap(Entry<K, V> e) {
        CacheEntry<K, V> currentEntry = this.heapCache.returnCacheEntry(e);
        if (this.syncEntryEvictedListeners != null) {
            for (CacheEntryEvictedListener<K, V> l : this.syncEntryEvictedListeners) {
                try {
                    l.onEntryEvicted(this.getUserCache(), currentEntry);
                }
                catch (Throwable t) {
                    this.getLog().warn("Exception from eviction listener", t);
                }
            }
        }
    }

    @Override
    protected <R> EntryAction<K, V, R> createEntryAction(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        return new MyEntryAction<R>(op, key, e);
    }

    @Override
    public String getEntryState(K key) {
        return this.heapCache.getEntryState(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventExpireEntry(Entry<K, V> e, Object task) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
            long nrt = e.getNextRefreshTime();
            long now = this.heapCache.clock.millis();
            if (now < Math.abs(nrt)) {
                if (nrt > 0L) {
                    this.heapCache.timing.scheduleFinalTimerForSharpExpiry(e);
                    e.setNextRefreshTime(-nrt);
                }
                return;
            }
        }
        this.enqueueTimerAction(e, this.ops.expireEvent);
    }

    private <R> void enqueueTimerAction(Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction action = this.createFireAndForgetAction((Entry)e, (Semantic)op);
        this.getExecutor().execute(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventRefresh(Entry<K, V> e, Object task) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
            if (this.asyncLoader != null) {
                this.enqueueTimerAction(e, this.ops.refresh);
                return;
            }
            try {
                this.heapCache.getRefreshExecutor().execute(this.createFireAndForgetAction((Entry)e, this.ops.refresh));
            }
            catch (RejectedExecutionException ex) {
                this.metrics().refreshRejected();
                this.enqueueTimerAction(e, this.ops.expireEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventProbationTerminated(Entry<K, V> e, Object task) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
        }
        this.enqueueTimerAction(e, this.ops.expireEvent);
    }

    @Override
    public Cache<K, V> getUserCache() {
        return this.userCache;
    }

    class MyEntryAction<R>
    extends EntryAction<K, V, R> {
        MyEntryAction(Semantic<K, V, R> op, K k, Entry<K, V> e) {
            super(WiredCache.this.heapCache, WiredCache.this, op, k, e);
        }

        MyEntryAction(Semantic<K, V, R> op, K k, Entry<K, V> e, EntryAction.CompletedCallback cb) {
            super(WiredCache.this.heapCache, WiredCache.this, op, k, e, cb);
        }

        @Override
        protected boolean mightHaveListeners() {
            return true;
        }

        @Override
        protected CacheEntryCreatedListener<K, V>[] entryCreatedListeners() {
            return WiredCache.this.syncEntryCreatedListeners;
        }

        @Override
        protected CacheEntryRemovedListener<K, V>[] entryRemovedListeners() {
            return WiredCache.this.syncEntryRemovedListeners;
        }

        @Override
        protected CacheEntryUpdatedListener<K, V>[] entryUpdatedListeners() {
            return WiredCache.this.syncEntryUpdatedListeners;
        }

        @Override
        protected CacheEntryExpiredListener<K, V>[] entryExpiredListeners() {
            return WiredCache.this.syncEntryExpiredListeners;
        }

        @Override
        protected CacheWriter<K, V> writer() {
            return WiredCache.this.writer;
        }

        @Override
        protected Timing<K, V> timing() {
            return this.heapCache.timing;
        }

        public Executor getLoaderExecutor() {
            return this.heapCache.getLoaderExecutor();
        }

        @Override
        protected AsyncCacheLoader<K, V> asyncLoader() {
            return WiredCache.this.asyncLoader;
        }

        @Override
        protected Executor executor() {
            return this.heapCache.getExecutor();
        }

        @Override
        public Executor getExecutor() {
            return this.executor();
        }

        @Override
        public ExceptionPropagator getExceptionPropagator() {
            return this.heapCache.exceptionPropagator;
        }
    }
}

