/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class SingleProviderResolver {
    private static final Map<Class, Object> PROVIDERS = new HashMap<Class, Object>();

    public static <T> T resolveMandatory(Class<T> c) {
        T obj = SingleProviderResolver.resolve(c);
        if (obj == null) {
            LinkageError err = new LinkageError("No implementation found for: " + c.getName());
            throw err;
        }
        return obj;
    }

    public static <T> T resolve(Class<T> c) {
        return SingleProviderResolver.resolve(c, null);
    }

    public static synchronized <T> T resolve(Class<T> c, Class<? extends T> defaultImpl) {
        if (PROVIDERS.containsKey(c)) {
            return (T)PROVIDERS.get(c);
        }
        T impl = null;
        Iterator<T> it = ServiceLoader.load(c).iterator();
        if (it.hasNext()) {
            impl = it.next();
        }
        if (impl == null && defaultImpl != null) {
            try {
                impl = defaultImpl.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LinkageError err = new LinkageError("Error instantiating " + c.getName(), ex);
                err.printStackTrace();
                throw err;
            }
        }
        PROVIDERS.put(c, impl);
        return impl;
    }
}

