/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.cache2k.CacheEntry;
import org.cache2k.core.CompactEntry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.HeapCache;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.timing.TimerTask;
import org.cache2k.core.util.Util;
import org.cache2k.io.LoadExceptionInfo;
import org.cache2k.operation.TimeReference;

public class Entry<K, V>
extends CompactEntry<K, V>
implements ExaminationEntry<K, V> {
    public static final int EXPIRY_TIME_MIN = 32;
    public static final int DATA_VALID = 16;
    public static final int VIRGIN = 0;
    public static final int READ_NON_VALID = 1;
    public static final int REMOVE_PENDING = 2;
    public static final int ABORTED = 3;
    public static final int EXPIRED = 4;
    public static final int EXPIRED_REFRESH_PENDING = 5;
    public static final int EXPIRED_REFRESHED = 6;
    public static final int GONE = 8;
    public static final int GONE_OTHER = 15;
    private Object misc;
    private volatile long refreshTimeAndState;
    private static final AtomicLongFieldUpdater<Entry> STATE_UPDATER = AtomicLongFieldUpdater.newUpdater(Entry.class, "refreshTimeAndState");
    public Entry next;
    public Entry prev;
    private int hotAndWeight;
    private static final int MODIFICATION_TIME_BITS = 44;
    private static final long MODIFICATION_TIME_BASE = 0L;
    private static final int MODIFICATION_TIME_SHIFT = 1;
    private static final long MODIFICATION_TIME_MASK = 0xFFFFFFFFFFFL;
    private static final int PS_BITS = 5;
    private static final int PS_MASK = 31;
    private static final int PS_POS = 44;
    private static final Entry LIST_REMOVED_MARKER = new Entry();

    public Entry(K key, int hashCode) {
        super(key, hashCode);
    }

    public Entry() {
        this(null, 0);
    }

    public CacheEntry<K, V> getInspectionEntry() {
        Object obj = this.getValueOrException();
        if (obj instanceof ExceptionWrapper) {
            return null;
        }
        return this;
    }

    public void setRefreshTime(long t) {
        this.refreshTimeAndState = this.refreshTimeAndState & 0xFFFFF00000000000L | t - 0L << 1 & 0xFFFFFFFFFFFL;
    }

    @Override
    public long getModificationTime() {
        return (this.refreshTimeAndState & 0xFFFFFFFFFFFL) >> 1;
    }

    public static String num2processingStateText(int ps) {
        switch (ps) {
            case 0: {
                return "DONE";
            }
            case 1: {
                return "READ";
            }
            case 2: {
                return "READ_COMPLETE";
            }
            case 3: {
                return "MUTATE";
            }
            case 4: {
                return "LOAD";
            }
            case 5: {
                return "LOAD_COMPLETE";
            }
            case 6: {
                return "COMPUTE";
            }
            case 7: {
                return "REFRESH";
            }
            case 8: {
                return "EXPIRY";
            }
            case 9: {
                return "EXPIRY_COMPLETE";
            }
            case 10: {
                return "WRITE";
            }
            case 11: {
                return "WRITE_COMPLETE";
            }
            case 12: {
                return "STORE";
            }
            case 13: {
                return "STORE_COMPLETE";
            }
            case 14: {
                return "NOTIFY";
            }
            case 15: {
                return "PINNED";
            }
            case 16: {
                return "EVICT";
            }
            case 17: {
                return "LOAD_ASYNC";
            }
            case 18: {
                return "WRITE_ASYNC";
            }
            case 20: {
                return "LAST";
            }
        }
        return "UNKNOWN";
    }

    public int getProcessingState() {
        return (int)(this.refreshTimeAndState >> 44 & 0x1FL);
    }

    private void setProcessingState(int v) {
        this.refreshTimeAndState = this.withState(this.refreshTimeAndState, v);
    }

    private long withState(long refreshTimeAndState, long state) {
        return refreshTimeAndState & 0xFFFE0FFFFFFFFFFFL | state << 44;
    }

    public boolean checkAndSwitchProcessingState(int ps0, int ps) {
        long rt = this.refreshTimeAndState;
        long expect = this.withState(rt, ps0);
        long update = this.withState(rt, ps);
        return STATE_UPDATER.compareAndSet(this, expect, update);
    }

    public void startProcessing(int ps, EntryAction action) {
        this.setProcessingState(ps);
        if (action != null) {
            this.setEntryAction(action);
        }
    }

    public void nextProcessingStep(int ps) {
        this.setProcessingState(ps);
    }

    public void processingDone(EntryAction action) {
        this.processingDone();
    }

    public void processingDone() {
        this.notifyAll();
        this.setProcessingState(0);
        this.resetEntryAction();
    }

    public long getNextRefreshTime() {
        return this.nextRefreshTime;
    }

    @Override
    public long getExpiryTime() {
        return this.isDataAvailable() ? this.nextRefreshTime : -1L;
    }

    public void setNextRefreshTime(long nextRefreshTime) {
        this.nextRefreshTime = nextRefreshTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureAbort(boolean finished) {
        if (finished) {
            return;
        }
        Entry entry = this;
        synchronized (entry) {
            if (this.isVirgin()) {
                this.nextRefreshTime = 3L;
            }
            if (this.isProcessing()) {
                this.processingDone();
            }
        }
    }

    public boolean isProcessing() {
        return this.getProcessingState() != 0;
    }

    public void waitForProcessing() {
        if (!this.isProcessing()) {
            return;
        }
        boolean interrupt = false;
        do {
            try {
                this.wait();
            }
            catch (InterruptedException ignore) {
                interrupt = true;
            }
        } while (this.isProcessing());
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isGettingRefresh() {
        return this.getProcessingState() == 7;
    }

    public final void removedFromList() {
        this.next = LIST_REMOVED_MARKER;
        this.prev = null;
    }

    public boolean isRemovedFromReplacementList() {
        return this.next == LIST_REMOVED_MARKER;
    }

    public boolean isNotYetInsertedInReplacementList() {
        return this.next == null;
    }

    public Entry shortCircuit() {
        this.next = this.prev = this;
        return this.prev;
    }

    public final boolean isVirgin() {
        return this.nextRefreshTime == 0L;
    }

    public final boolean isDataAvailable() {
        return this.nextRefreshTime >= 16L || this.nextRefreshTime < 0L;
    }

    public final boolean isDataAvailableOrProbation() {
        return this.isDataAvailable() || this.nextRefreshTime == 6L;
    }

    public final boolean isValidOrExpiredAndNoException() {
        return (this.isDataAvailable() || this.isExpiredState()) && !this.hasException();
    }

    public final boolean hasFreshData(TimeReference t) {
        long nrt = this.nextRefreshTime;
        if (nrt >= 16L) {
            return true;
        }
        if (Entry.needsTimeCheck(nrt)) {
            return t.millis() < -nrt;
        }
        return false;
    }

    public boolean isExpiredState() {
        return this.nextRefreshTime == 4L;
    }

    public void setGone() {
        long nrt = this.nextRefreshTime;
        if (nrt >= 0L && nrt < 8L) {
            this.nextRefreshTime = 8L + nrt;
            return;
        }
        this.nextRefreshTime = 15L;
    }

    public final boolean isGone() {
        long nrt = this.nextRefreshTime;
        return nrt >= 8L && nrt <= 15L;
    }

    public final boolean needsTimeCheck() {
        return Entry.needsTimeCheck(this.nextRefreshTime);
    }

    public static boolean needsTimeCheck(long nextRefreshTime) {
        return nextRefreshTime < 0L;
    }

    public boolean isHot() {
        return this.hotAndWeight < 0;
    }

    public void setHot(boolean f) {
        this.hotAndWeight = f ? (this.hotAndWeight |= Integer.MIN_VALUE) : (this.hotAndWeight &= Integer.MAX_VALUE);
    }

    public void setCompressedWeight(int v) {
        this.hotAndWeight = this.hotAndWeight & Integer.MIN_VALUE | v;
    }

    public int getCompressedWeight() {
        return this.hotAndWeight & Integer.MAX_VALUE;
    }

    public long getValueExpiryTime() {
        if (this.nextRefreshTime < 0L) {
            return -this.nextRefreshTime;
        }
        if (this.nextRefreshTime > 32L) {
            return this.nextRefreshTime;
        }
        return 0L;
    }

    public String toString(HeapCache c) {
        long nrt;
        StringBuilder sb = new StringBuilder();
        sb.append("Entry{");
        sb.append("id=").append(System.identityHashCode(this));
        sb.append(", lock=").append(Entry.num2processingStateText(this.getProcessingState()));
        sb.append(", key=");
        Object key = this.getKeyObj();
        if (key == null) {
            sb.append(this.hashCode);
        } else {
            sb.append(key);
            if (c != null && HeapCache.spreadHash(key.hashCode()) != this.hashCode) {
                sb.append(", keyMutation=true");
            }
        }
        Object valueOrException = this.getValueOrException();
        if (valueOrException instanceof ExceptionWrapper) {
            sb.append(", exception=").append(((ExceptionWrapper)valueOrException).getException().getClass().getSimpleName());
        } else if (valueOrException != null) {
            sb.append(", valueId=").append(System.identityHashCode(valueOrException));
        } else {
            sb.append(", value=null");
        }
        long t = this.getModificationTime();
        if (t > 0L) {
            sb.append(", refresh=").append(Util.formatMillis(t));
        }
        if ((nrt = this.nextRefreshTime) < 0L) {
            sb.append(", nextRefreshTime(sharp)=").append(Util.formatMillis(-nrt));
        } else if (nrt == Long.MAX_VALUE) {
            sb.append(", nextRefreshTime=ETERNAL");
        } else if (nrt >= 32L) {
            sb.append(", nextRefreshTime(timer)=").append(Util.formatMillis(nrt));
        } else {
            sb.append(", state=").append(nrt);
        }
        if (Thread.holdsLock(this)) {
            if (this.getTask() != null) {
                sb.append(", timerState=").append(this.getTask());
            } else {
                sb.append(", noTimer");
            }
        } else {
            sb.append(", timerState=?");
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public TimerTask getTask() {
        if (this.misc instanceof TimerTask) {
            return (TimerTask)this.misc;
        }
        TaskPiggyBack pb = this.getPiggyBack(TaskPiggyBack.class);
        if (pb != null) {
            return pb.task;
        }
        return null;
    }

    public <X> X getPiggyBack(Class<X> type) {
        Object obj = this.misc;
        if (!(obj instanceof PiggyBack)) {
            return null;
        }
        PiggyBack pb = (PiggyBack)obj;
        do {
            if (pb.getClass() != type) continue;
            return (X)pb;
        } while ((pb = pb.next) != null);
        return null;
    }

    public void setTask(TimerTask v) {
        if (this.misc == null || this.misc instanceof TimerTask) {
            this.misc = v;
            return;
        }
        TaskPiggyBack pb = this.getPiggyBack(TaskPiggyBack.class);
        if (pb != null) {
            pb.task = v;
            return;
        }
        this.misc = new TaskPiggyBack(v, (PiggyBack)this.misc);
    }

    public void setEntryAction(EntryAction action) {
        action.next = this.existingPiggyBackForInserting();
        this.misc = action;
    }

    public EntryAction getEntryAction() {
        if (!(this.misc instanceof PiggyBack)) {
            return null;
        }
        PiggyBack at = (PiggyBack)this.misc;
        while (at != null) {
            if (at instanceof EntryAction) {
                return (EntryAction)at;
            }
            at = at.next;
        }
        return null;
    }

    public void resetEntryAction() {
        if (!(this.misc instanceof PiggyBack)) {
            return;
        }
        if (this.misc instanceof EntryAction) {
            this.misc = ((PiggyBack)this.misc).next;
            return;
        }
        PiggyBack at = (PiggyBack)this.misc;
        while (at != null) {
            PiggyBack next = at.next;
            if (next instanceof EntryAction) {
                at.next = next.next;
                return;
            }
            at = next;
        }
    }

    private PiggyBack existingPiggyBackForInserting() {
        Object misc = this.misc;
        if (misc instanceof TimerTask) {
            return new TaskPiggyBack((TimerTask)misc, null);
        }
        return (PiggyBack)misc;
    }

    public void setSuppressedLoadExceptionInformation(LoadExceptionInfo w) {
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        if (inf != null) {
            inf.info = w;
            return;
        }
        this.misc = new LoadExceptionPiggyBack(w, this.existingPiggyBackForInserting());
    }

    public void resetSuppressedLoadExceptionInformation() {
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        if (inf != null) {
            inf.info = null;
        }
    }

    public LoadExceptionInfo getSuppressedLoadExceptionInformation() {
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        return inf != null ? inf.info : null;
    }

    public void setRefreshProbationNextRefreshTime(long nrt) {
        RefreshProbationPiggyBack inf = this.getPiggyBack(RefreshProbationPiggyBack.class);
        if (inf != null) {
            inf.nextRefreshTime = nrt;
            return;
        }
        this.misc = new RefreshProbationPiggyBack(nrt, this.existingPiggyBackForInserting());
    }

    public long getRefreshProbationNextRefreshTime() {
        RefreshProbationPiggyBack inf = this.getPiggyBack(RefreshProbationPiggyBack.class);
        return inf != null ? inf.nextRefreshTime : 0L;
    }

    public static void removeFromList(Entry e) {
        e.prev.next = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
    }

    public static void insertInList(Entry head, Entry e) {
        e.prev = head;
        e.next = head.next;
        e.next.prev = e;
        head.next = e;
    }

    public static <E extends Entry> E insertIntoTailCyclicList(E head, E e) {
        if (head == null) {
            return (E)e.shortCircuit();
        }
        e.next = head;
        e.prev = head.prev;
        head.prev = e;
        e.prev.next = e;
        return head;
    }

    public static <E extends Entry> E removeFromCyclicList(E head, E e) {
        Entry eNext;
        if (e.next == e) {
            e.removedFromList();
            return null;
        }
        e.prev.next = eNext = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
        return (E)(e == head ? eNext : head);
    }

    public static Entry removeFromCyclicList(Entry e) {
        Entry eNext;
        e.prev.next = eNext = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
        return eNext == e ? null : eNext;
    }

    public static int getCyclicListEntryCount(Entry e) {
        if (e == null) {
            return 0;
        }
        Entry head = e;
        int cnt = 0;
        do {
            ++cnt;
            e = e.next;
            if (e != null) continue;
            return -cnt;
        } while (e != head);
        return cnt;
    }

    public static boolean checkCyclicListIntegrity(Entry e) {
        if (e == null) {
            return true;
        }
        Entry head = e;
        do {
            if (e.next == null) {
                return false;
            }
            if (e.next.prev == e) continue;
            return false;
        } while ((e = e.next) != head);
        return true;
    }

    static class RefreshProbationPiggyBack
    extends PiggyBack {
        long nextRefreshTime;

        RefreshProbationPiggyBack(long nextRefreshTime, PiggyBack next) {
            super(next);
            this.nextRefreshTime = nextRefreshTime;
        }
    }

    static class LoadExceptionPiggyBack
    extends PiggyBack {
        LoadExceptionInfo info;

        LoadExceptionPiggyBack(LoadExceptionInfo info, PiggyBack next) {
            super(next);
            this.info = info;
        }
    }

    static class TaskPiggyBack
    extends PiggyBack {
        TimerTask task;

        TaskPiggyBack(TimerTask task, PiggyBack next) {
            super(next);
            this.task = task;
        }
    }

    static class PiggyBack {
        PiggyBack next;

        PiggyBack(PiggyBack next) {
            this.next = next;
        }
    }

    public static class ProcessingState {
        public static final int DONE = 0;
        public static final int READ = 1;
        public static final int READ_COMPLETE = 2;
        public static final int MUTATE = 3;
        public static final int LOAD = 4;
        public static final int LOAD_COMPLETE = 5;
        public static final int COMPUTE = 6;
        public static final int REFRESH = 7;
        public static final int EXPIRY = 8;
        public static final int EXPIRY_COMPLETE = 9;
        public static final int WRITE = 10;
        public static final int WRITE_COMPLETE = 11;
        public static final int STORE = 12;
        public static final int STORE_COMPLETE = 13;
        public static final int NOTIFY = 14;
        public static final int PINNED = 15;
        public static final int EVICT = 16;
        public static final int LOAD_ASYNC = 17;
        public static final int WRITE_ASYNC = 18;
        public static final int EXPIRE = 19;
        public static final int LAST = 20;
    }
}

