/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import java.time.Duration;
import org.cache2k.CacheEntry;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.core.Entry;
import org.cache2k.core.api.InternalCacheBuildContext;
import org.cache2k.core.api.InternalCacheCloseContext;
import org.cache2k.core.api.NeedsClose;
import org.cache2k.core.timing.DynamicTiming;
import org.cache2k.core.timing.StaticTiming;
import org.cache2k.core.timing.TimeAgnosticTiming;
import org.cache2k.core.timing.TimerEventListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.expiry.ValueWithExpiryTime;
import org.cache2k.io.LoadExceptionInfo;
import org.cache2k.io.ResiliencePolicy;

public abstract class Timing<K, V>
implements NeedsClose {
    static final ExpiryPolicy<?, ValueWithExpiryTime> ENTRY_EXPIRY_CALCULATOR_FROM_VALUE = new ExpiryPolicy<Object, ValueWithExpiryTime>(){

        public long calculateExpiryTime(Object key, ValueWithExpiryTime value, long loadTime, CacheEntry<Object, ValueWithExpiryTime> currentEntry) {
            return value.getCacheExpiryTime();
        }
    };

    static boolean realDuration(Duration d) {
        return d != null && !Duration.ZERO.equals(d) && d != Cache2kConfig.EXPIRY_ETERNAL;
    }

    static boolean realDuration(long t) {
        return t > 0L && t < Long.MAX_VALUE;
    }

    static boolean zeroOrUnspecified(Duration t) {
        return t == null || t.equals(Duration.ZERO);
    }

    static boolean zeroOrUnspecified(long t) {
        return t == 0L || t == -1L;
    }

    public static <K, V> Timing<K, V> of(InternalCacheBuildContext<K, V> ctx) {
        Cache2kConfig<K, V> cfg = ctx.getConfig();
        if (Duration.ZERO.equals(cfg.getExpireAfterWrite())) {
            return TimeAgnosticTiming.IMMEDIATE;
        }
        ResiliencePolicy resiliencePolicy = ctx.createCustomization(cfg.getResiliencePolicy(), ResiliencePolicy.disabledPolicy());
        if (cfg.getExpiryPolicy() != null || cfg.getValueType() != null && ValueWithExpiryTime.class.isAssignableFrom(cfg.getValueType().getType()) || resiliencePolicy != ResiliencePolicy.DISABLED_POLICY) {
            DynamicTiming<K, V> h = new DynamicTiming<K, V>(ctx, resiliencePolicy);
            return h;
        }
        if (Timing.realDuration(cfg.getExpireAfterWrite())) {
            StaticTiming<K, V> h = new StaticTiming<K, V>(ctx, resiliencePolicy);
            return h;
        }
        return TimeAgnosticTiming.ETERNAL_IMMEDIATE;
    }

    public void setTarget(TimerEventListener<K, V> c) {
    }

    public void cancelAll() {
    }

    @Override
    public void close(InternalCacheCloseContext closeContext) {
    }

    public abstract long calculateNextRefreshTime(Entry<K, V> var1, V var2, long var3);

    public abstract long suppressExceptionUntil(Entry<K, V> var1, LoadExceptionInfo var2);

    public abstract long cacheExceptionUntil(Entry<K, V> var1, LoadExceptionInfo var2);

    public long stopStartTimer(long expiryTime, Entry<K, V> e) {
        if (expiryTime > 0L && expiryTime < Long.MAX_VALUE || expiryTime < 0L) {
            throw new IllegalArgumentException("Cache is not configured for variable expiry");
        }
        return expiryTime == 0L ? 4L : expiryTime;
    }

    public boolean startRefreshProbationTimer(Entry<K, V> e, long nextRefreshTime) {
        return true;
    }

    public void cancelExpiryTimer(Entry<K, V> e) {
    }

    public void scheduleFinalTimerForSharpExpiry(Entry<K, V> e) {
    }
}

