/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.core.Entry;
import org.cache2k.core.timing.Timing;
import org.cache2k.io.LoadExceptionInfo;

public abstract class TimeAgnosticTiming<K, V>
extends Timing<K, V> {
    public static final Timing ETERNAL = new EternalTiming();
    public static final Timing ETERNAL_IMMEDIATE = new EternalImmediate();
    public static final Timing IMMEDIATE = new Immediate();

    static class EternalTiming<K, V>
    extends TimeAgnosticTiming<K, V> {
        EternalTiming() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long loadTime) {
            return Long.MAX_VALUE;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
            return Long.MAX_VALUE;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
            return Long.MAX_VALUE;
        }
    }

    static class Immediate<K, V>
    extends TimeAgnosticTiming<K, V> {
        Immediate() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long loadTime) {
            return 0L;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
            return 0L;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
            return 0L;
        }
    }

    static class EternalImmediate<K, V>
    extends TimeAgnosticTiming<K, V> {
        EternalImmediate() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long loadTime) {
            return Long.MAX_VALUE;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
            return 0L;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
            return 0L;
        }
    }
}

