/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.operation;

import java.util.function.Function;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.MutableEntryOnProgress;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.ResultEntry;
import org.cache2k.core.operation.Semantic;
import org.cache2k.io.CacheLoaderException;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessor;
import org.cache2k.processor.RestartException;

public class Operations<K, V> {
    public static final Operations SINGLETON = new Operations();
    static final Semantic PEEK = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isDataFreshOrMiss()) {
                c.result(e.getValueOrException());
            }
            c.noMutation();
        }
    };
    public static final Semantic GET = new Semantic.MightUpdate(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isDataFreshOrMiss()) {
                c.result(e.getValueOrException());
                c.noMutation();
            } else if (c.isLoaderPresent()) {
                c.wantMutation();
            } else {
                c.noMutation();
            }
        }

        @Override
        public void mutate(Progress c, ExaminationEntry e) {
            c.load();
        }
    };
    public final Semantic unconditionalLoad = new Semantic.InsertOrUpdate(){

        @Override
        public void mutate(Progress c, ExaminationEntry e) {
            c.load();
        }
    };
    public final Semantic<K, V, Void> refresh = new Semantic.MightUpdate<K, V, Void>(){

        @Override
        public void examine(Progress<K, V, Void> c, ExaminationEntry<K, V> e) {
            if (c.isDataRefreshing() || c.isExpiryTimeReachedOrInRefreshProbation()) {
                c.wantMutation();
            } else {
                c.noMutation();
            }
        }

        @Override
        public void mutate(Progress<K, V, Void> c, ExaminationEntry<K, V> e) {
            c.refresh();
        }
    };
    static final Semantic GET_ENTRY = new Semantic.MightUpdate(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isDataFreshOrMiss()) {
                c.entryResult(e);
                c.noMutation();
            } else if (c.isLoaderPresent()) {
                c.wantMutation();
            } else {
                c.noMutation();
            }
        }

        @Override
        public void mutate(Progress c, ExaminationEntry e) {
            c.load();
        }

        @Override
        public void loaded(Progress c, ExaminationEntry e) {
            c.entryResult(e);
        }
    };
    static final Semantic PEEK_ENTRY = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isDataFreshOrMiss()) {
                c.entryResult(e);
            }
            c.noMutation();
        }
    };
    static final Semantic REMOVE = new Semantic.InsertOrUpdate(){

        @Override
        public void mutate(Progress c, ExaminationEntry e) {
            c.remove();
        }
    };
    static final Semantic CONTAINS_REMOVE = new Semantic.Update(){

        @Override
        public void mutate(Progress c, ExaminationEntry e) {
            if (c.isDataFresh()) {
                c.result(true);
                c.remove();
                return;
            }
            c.result(false);
            c.remove();
        }
    };
    static final Semantic CONTAINS = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            c.result(c.isDataFresh());
            c.noMutation();
        }
    };
    static final Semantic PEEK_REMOVE = new Semantic.Update(){

        @Override
        public void mutate(Progress c, ExaminationEntry e) {
            if (c.isDataFreshOrMiss()) {
                c.result(e.getValueOrException());
            }
            c.remove();
        }
    };
    public final Semantic<K, V, Void> expireEvent = new ExpireEvent();

    public Semantic<K, V, V> peek(K key) {
        return PEEK;
    }

    public Semantic<K, V, V> get(K key) {
        return GET;
    }

    public Semantic<K, V, ResultEntry<K, V>> getEntry(K key) {
        return GET_ENTRY;
    }

    public Semantic<K, V, ResultEntry<K, V>> peekEntry(K key) {
        return PEEK_ENTRY;
    }

    public Semantic<K, V, V> remove(K key) {
        return REMOVE;
    }

    public Semantic<K, V, Boolean> containsAndRemove(K key) {
        return CONTAINS_REMOVE;
    }

    public Semantic<K, V, Boolean> contains(K key) {
        return CONTAINS;
    }

    public Semantic<K, V, V> peekAndRemove(K key) {
        return PEEK_REMOVE;
    }

    public Semantic<K, V, V> peekAndReplace(K key, final V value) {
        return new Semantic.MightUpdate<K, V, V>(){

            @Override
            public void examine(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                if (c.isDataFreshOrMiss()) {
                    c.result(e.getValueOrException());
                    c.wantMutation();
                    return;
                }
                c.noMutation();
            }

            @Override
            public void mutate(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                c.put(value);
            }
        };
    }

    public Semantic<K, V, V> peekAndPut(K key, final V value) {
        return new Semantic.Update<K, V, V>(){

            @Override
            public void mutate(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                if (c.isDataFreshOrMiss()) {
                    c.result(e.getValueOrException());
                }
                c.put(value);
            }
        };
    }

    public Semantic<K, V, V> computeIfAbsent(K key, final Function<? super K, ? extends V> function) {
        return new Semantic.MightUpdate<K, V, V>(){

            @Override
            public void examine(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                if (c.isDataFreshOrMiss()) {
                    c.result(e.getValueOrException());
                    c.noMutation();
                } else {
                    c.wantMutation();
                }
            }

            @Override
            public void mutate(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                try {
                    Object value = function.apply(e.getKey());
                    c.result(value);
                    c.put(value);
                }
                catch (RuntimeException ex) {
                    c.failure(ex);
                }
                catch (Exception ex) {
                    c.failure((RuntimeException)new CacheLoaderException((Throwable)ex));
                }
            }
        };
    }

    public Semantic<K, V, V> put(K key, final V value) {
        return new Semantic.InsertOrUpdate<K, V, V>(){

            @Override
            public void mutate(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                c.put(value);
            }
        };
    }

    public Semantic<K, V, Boolean> putIfAbsent(K key, final V value) {
        return new Semantic.MightUpdate<K, V, Boolean>(){

            @Override
            public void examine(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (!c.isDataFreshOrMiss()) {
                    c.result(true);
                    c.wantMutation();
                } else {
                    c.result(false);
                    c.noMutation();
                }
            }

            @Override
            public void mutate(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                c.put(value);
            }
        };
    }

    public Semantic<K, V, Boolean> replace(K key, final V value) {
        return new Semantic.MightUpdate<K, V, Boolean>(){

            @Override
            public void examine(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isDataFreshOrMiss()) {
                    c.result(true);
                    c.wantMutation();
                } else {
                    c.result(false);
                    c.noMutation();
                }
            }

            @Override
            public void mutate(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                c.put(value);
            }
        };
    }

    public Semantic<K, V, Boolean> replace(K key, final V value, final V newValue) {
        return new Semantic.MightUpdate<K, V, Boolean>(){

            @Override
            public void examine(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isDataFreshOrMiss() && (value == e.getValueOrException() || value != null && value.equals(e.getValueOrException()))) {
                    c.result(true);
                    c.wantMutation();
                } else {
                    c.result(false);
                    c.noMutation();
                }
            }

            @Override
            public void mutate(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                c.put(newValue);
            }
        };
    }

    public Semantic<K, V, Boolean> remove(K key, final V value) {
        return new Semantic.MightUpdate<K, V, Boolean>(){

            @Override
            public void examine(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isDataFreshOrMiss() && (value == null && e.getValueOrException() == null || value.equals(e.getValueOrException()))) {
                    c.result(true);
                    c.wantMutation();
                } else {
                    c.result(false);
                    c.noMutation();
                }
            }

            @Override
            public void mutate(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                c.remove();
            }
        };
    }

    public <R> Semantic<K, V, R> invoke(final K key, final EntryProcessor<K, V, R> processor) {
        return new Semantic.Base<K, V, R>(){
            private MutableEntryOnProgress<K, V> mutableEntryResult;
            private boolean needsLoad;
            private boolean needsLock;

            @Override
            public void start(Progress<K, V, R> c) {
                MutableEntryOnProgress mutableEntry = new MutableEntryOnProgress(key, c, null, false);
                try {
                    Object result = processor.process(mutableEntry);
                    c.result(result);
                }
                catch (WantsDataRestartException rs) {
                    c.wantData();
                    return;
                }
                catch (NeedsLockRestartException ex) {
                    this.needsLock = true;
                    c.wantData();
                    return;
                }
                catch (Throwable t) {
                    c.failure((RuntimeException)((Object)new EntryProcessingException(t)));
                    return;
                }
                this.maybeMutate(c, mutableEntry);
            }

            @Override
            public void examine(Progress<K, V, R> c, ExaminationEntry<K, V> e) {
                if (this.needsLock) {
                    c.wantMutation();
                    return;
                }
                MutableEntryOnProgress mutableEntry = new MutableEntryOnProgress(key, c, e, false);
                try {
                    Object result = processor.process(mutableEntry);
                    c.result(result);
                }
                catch (NeedsLockRestartException ex) {
                    c.wantMutation();
                    return;
                }
                catch (NeedsLoadRestartException rs) {
                    this.needsLoad = true;
                    c.wantMutation();
                    return;
                }
                catch (Throwable t) {
                    c.failure((RuntimeException)((Object)new EntryProcessingException(t)));
                    return;
                }
                this.maybeMutate(c, mutableEntry);
            }

            private void maybeMutate(Progress<K, V, R> c, MutableEntryOnProgress<K, V> mutableEntry) {
                if (mutableEntry.isMutationNeeded()) {
                    this.mutableEntryResult = mutableEntry;
                    c.wantMutation();
                } else {
                    c.noMutation();
                }
            }

            @Override
            public void mutate(Progress<K, V, R> c, ExaminationEntry<K, V> e) {
                if (this.needsLoad) {
                    this.needsLoad = false;
                    c.loadAndRestart();
                    return;
                }
                if (this.mutableEntryResult == null) {
                    this.mutableEntryResult = new MutableEntryOnProgress(key, c, e, true);
                    try {
                        Object result = processor.process(this.mutableEntryResult);
                        c.result(result);
                    }
                    catch (Throwable t) {
                        c.failure((RuntimeException)((Object)new EntryProcessingException(t)));
                        return;
                    }
                }
                this.mutableEntryResult.sendMutationCommand();
            }

            @Override
            public void loaded(Progress<K, V, R> c, ExaminationEntry<K, V> e) {
            }
        };
    }

    public Semantic<K, V, Void> expire(K key, final long time) {
        return new Semantic.MightUpdate<K, V, Void>(){

            @Override
            public void examine(Progress<K, V, Void> c, ExaminationEntry<K, V> e) {
                if (c.isDataFresh() || c.isDataRefreshing()) {
                    c.wantMutation();
                } else {
                    c.noMutation();
                }
            }

            @Override
            public void mutate(Progress c, ExaminationEntry e) {
                c.expire(time);
            }
        };
    }

    public static class ExpireEvent<K, V>
    extends Semantic.MightUpdate<K, V, Void> {
        @Override
        public void examine(Progress<K, V, Void> c, ExaminationEntry<K, V> e) {
            if (c.isExpiryTimeReachedOrInRefreshProbation()) {
                c.wantMutation();
                return;
            }
            c.noMutation();
        }

        @Override
        public void mutate(Progress<K, V, Void> c, ExaminationEntry<K, V> e) {
            c.expire(0L);
        }
    }

    public static class NeedsLockRestartException
    extends RestartException {
    }

    public static class NeedsLoadRestartException
    extends RestartException {
    }

    public static class WantsDataRestartException
    extends RestartException {
    }
}

