/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.event;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.event.AsyncEvent;

public class AsyncDispatcher<K> {
    private static final int KEY_LOCKS_MASK = 2 << 31 - Integer.numberOfLeadingZeros(Runtime.getRuntime().availableProcessors()) - 1;
    private static final Object[] KEY_LOCKS = new Object[KEY_LOCKS_MASK + 1];
    private final Map<K, Queue<AsyncEvent<K>>> keyQueue = new ConcurrentHashMap<K, Queue<AsyncEvent<K>>>();
    private Executor executor;
    private InternalCache cache;

    private static Object getLockObject(Object key) {
        int hc = key.hashCode();
        return KEY_LOCKS[hc & KEY_LOCKS_MASK];
    }

    public AsyncDispatcher(InternalCache cache, Executor executor) {
        this.cache = cache;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(final AsyncEvent<K> event) {
        K key = event.getKey();
        Object object = AsyncDispatcher.getLockObject(key);
        synchronized (object) {
            Queue<AsyncEvent<K>> q = this.keyQueue.get(key);
            if (q != null) {
                q.add(event);
                return;
            }
            q = new LinkedList<AsyncEvent<K>>();
            this.keyQueue.put(key, q);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AsyncDispatcher.this.runMoreOrStop(event);
            }
        };
        this.executor.execute(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMoreOrStop(AsyncEvent<K> event) {
        while (true) {
            try {
                event.execute();
            }
            catch (Throwable t) {
                this.cache.getLog().warn("Async event exception", t);
            }
            K key = event.getKey();
            Object object = AsyncDispatcher.getLockObject(key);
            synchronized (object) {
                Queue<AsyncEvent<K>> q = this.keyQueue.get(key);
                if (q.isEmpty()) {
                    this.keyQueue.remove(key);
                    return;
                }
                event = q.remove();
            }
        }
    }

    static {
        for (int i = 0; i < KEY_LOCKS.length; ++i) {
            AsyncDispatcher.KEY_LOCKS[i] = new Object();
        }
    }
}

