/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.common;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.cache2k.config.CacheType;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.common.AbstractCacheStatistics;
import org.cache2k.operation.CacheControl;
import org.cache2k.operation.CacheStatistics;

public class BaseCacheControl
implements CacheControl {
    private final InternalCache cache;

    public BaseCacheControl(InternalCache cache) {
        this.cache = cache;
    }

    public CacheType getKeyType() {
        return this.cache.getKeyType();
    }

    public CacheType getValueType() {
        return this.cache.getValueType();
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getManagerName() {
        return this.cache.getCacheManager().getName();
    }

    private InternalCacheInfo getInfo() {
        return this.cache.getInfo();
    }

    public long getSize() {
        return this.cache.getTotalEntryCount();
    }

    public long getEntryCapacity() {
        return this.getInfo().getHeapCapacity();
    }

    public long getCapacityLimit() {
        return this.isWeigherPresent() ? this.getTotalWeight() : this.getEntryCapacity();
    }

    public long getMaximumWeight() {
        return this.getInfo().getMaximumWeight();
    }

    public long getTotalWeight() {
        return this.getInfo().getTotalWeight();
    }

    public Instant getCreatedTime() {
        return Instant.ofEpochMilli(this.getInfo().getStartedTime());
    }

    public Instant getClearedTime() {
        return this.instantOrNull(this.getInfo().getClearedTime());
    }

    Instant instantOrNull(long millis) {
        return millis == 0L ? null : Instant.ofEpochMilli(millis);
    }

    public String getImplementation() {
        return this.getInfo().getImplementation();
    }

    public CompletableFuture<Void> clear() {
        this.cache.clear();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> removeAll() {
        this.cache.removeAll();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> changeCapacity(long entryCountOrWeight) {
        this.cache.getEviction().changeCapacity(entryCountOrWeight);
        return CompletableFuture.completedFuture(null);
    }

    public boolean isLoaderPresent() {
        return this.cache.isLoaderPresent();
    }

    public boolean isWeigherPresent() {
        return this.cache.isWeigherPresent();
    }

    public boolean isStatisticsEnabled() {
        return !(this.cache.getCommonMetrics() instanceof CommonMetrics.BlackHole);
    }

    public CacheStatistics sampleStatistics() {
        if (!this.isStatisticsEnabled()) {
            return null;
        }
        final InternalCacheInfo info = this.getInfo();
        return new AbstractCacheStatistics(){

            @Override
            protected InternalCacheInfo info() {
                return info;
            }
        };
    }

    public CompletableFuture<Void> close() {
        this.cache.close();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> destroy() {
        this.cache.close();
        return CompletableFuture.completedFuture(null);
    }
}

