/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.config.CacheType;
import org.cache2k.core.BaseCache;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.OperationCompletion;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.eviction.Eviction;
import org.cache2k.core.log.Log;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.timing.Timing;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryEvictedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.operation.TimeReference;
import org.cache2k.processor.EntryProcessor;

public class WiredCache<K, V>
extends BaseCache<K, V>
implements HeapCacheListener<K, V> {
    final Operations<K, V> ops = Operations.SINGLETON;
    Cache<K, V> userCache;
    HeapCache<K, V> heapCache;
    AdvancedCacheLoader<K, V> loader;
    AsyncCacheLoader<K, V> asyncLoader;
    CacheWriter<K, V> writer;
    CacheEntryRemovedListener<K, V>[] syncEntryRemovedListeners;
    CacheEntryCreatedListener<K, V>[] syncEntryCreatedListeners;
    CacheEntryUpdatedListener<K, V>[] syncEntryUpdatedListeners;
    CacheEntryExpiredListener<K, V>[] syncEntryExpiredListeners;
    CacheEntryEvictedListener<K, V>[] syncEntryEvictedListeners;

    private CommonMetrics.Updater metrics() {
        return this.heapCache.metrics;
    }

    @Override
    public Log getLog() {
        return this.heapCache.getLog();
    }

    public HeapCache getHeapCache() {
        return this.heapCache;
    }

    @Override
    public TimeReference getClock() {
        return this.heapCache.getClock();
    }

    @Override
    public boolean isNullValuePermitted() {
        return this.heapCache.isNullValuePermitted();
    }

    @Override
    public String getName() {
        return this.heapCache.getName();
    }

    @Override
    public CacheType getKeyType() {
        return this.heapCache.getKeyType();
    }

    @Override
    public CacheType getValueType() {
        return this.heapCache.getValueType();
    }

    @Override
    public CacheManager getCacheManager() {
        return this.heapCache.getCacheManager();
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> function) {
        return this.returnValue(this.execute(key, this.ops.computeIfAbsent((K)key, function)));
    }

    public V peekAndPut(K key, V value) {
        return this.returnValue(this.execute(key, this.ops.peekAndPut(key, value)));
    }

    public V peekAndRemove(K key) {
        return this.returnValue(this.execute(key, this.ops.peekAndRemove(key)));
    }

    public V peekAndReplace(K key, V value) {
        return this.returnValue(this.execute(key, this.ops.peekAndReplace(key, value)));
    }

    public CacheEntry<K, V> peekEntry(K key) {
        return this.execute(key, this.ops.peekEntry(key));
    }

    public boolean containsKey(K key) {
        return this.execute(key, this.ops.contains(key));
    }

    public boolean putIfAbsent(K key, V value) {
        return this.execute(key, this.ops.putIfAbsent(key, value));
    }

    public void put(K key, V value) {
        this.execute(key, this.ops.put(key, value));
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void remove(K key) {
        this.execute(key, this.ops.remove(key));
    }

    public boolean removeIfEquals(K key, V value) {
        return this.execute(key, this.ops.remove(key, value));
    }

    public boolean containsAndRemove(K key) {
        return this.execute(key, this.ops.containsAndRemove(key));
    }

    public boolean replace(K key, V newValue) {
        return this.execute(key, this.ops.replace(key, newValue));
    }

    public boolean replaceIfEquals(K key, V oldValue, V newValue) {
        return this.execute(key, this.ops.replace(key, oldValue, newValue));
    }

    public void loadAll(Iterable<? extends K> keys, CacheOperationCompletionListener l) {
        this.checkLoaderPresent();
        CacheOperationCompletionListener listener = l != null ? l : HeapCache.DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> keysToLoad = this.heapCache.checkAllPresent(keys);
        if (keysToLoad.isEmpty()) {
            listener.onCompleted();
            return;
        }
        if (this.asyncLoader != null) {
            this.loadAllWithAsyncLoader(listener, keysToLoad);
        } else {
            this.loadAllWithSyncLoader(listener, keysToLoad);
        }
    }

    private void loadAllWithAsyncLoader(CacheOperationCompletionListener listener, Set<K> keysToLoad) {
        final OperationCompletion<K> completion = new OperationCompletion<K>(keysToLoad, listener);
        EntryAction.CompletedCallback cb = new EntryAction.CompletedCallback<K, V, Void>(){

            @Override
            public void entryActionCompleted(EntryAction<K, V, Void> ea) {
                completion.complete(ea.getKey(), WiredCache.this.extractException(ea));
            }
        };
        Iterator<K> iterator = keysToLoad.iterator();
        while (iterator.hasNext()) {
            K k;
            K key = k = iterator.next();
            this.executeAsyncLoadOrRefresh(key, null, Operations.GET, cb);
        }
    }

    private void loadAllWithSyncLoader(CacheOperationCompletionListener listener, Set<K> keysToLoad) {
        OperationCompletion<K> completion = new OperationCompletion<K>(keysToLoad, listener);
        for (K key : keysToLoad) {
            this.heapCache.executeLoader(completion, key, () -> {
                this.execute(key, null, this.ops.get(key));
                EntryAction<Object, V, V> action = this.createEntryAction(key, null, this.ops.get(key));
                action.start();
                return this.extractException(action);
            });
        }
    }

    public void reloadAll(Iterable<? extends K> keys, CacheOperationCompletionListener l) {
        this.checkLoaderPresent();
        CacheOperationCompletionListener listener = l != null ? l : HeapCache.DUMMY_LOAD_COMPLETED_LISTENER;
        Set<? extends K> keySet = this.heapCache.generateKeySet(keys);
        if (this.asyncLoader != null) {
            this.reloadAllWithAsyncLoader(listener, keySet);
        } else {
            this.reloadAllWithSyncLoader(listener, keySet);
        }
    }

    private void reloadAllWithAsyncLoader(CacheOperationCompletionListener listener, Set<K> keysToLoad) {
        final OperationCompletion<K> completion = new OperationCompletion<K>(keysToLoad, listener);
        EntryAction.CompletedCallback cb = new EntryAction.CompletedCallback<K, V, Void>(){

            @Override
            public void entryActionCompleted(EntryAction<K, V, Void> ea) {
                completion.complete(ea.getKey(), WiredCache.this.extractException(ea));
            }
        };
        Iterator<K> iterator = keysToLoad.iterator();
        while (iterator.hasNext()) {
            K k;
            K key = k = iterator.next();
            this.executeAsyncLoadOrRefresh(key, null, this.ops.unconditionalLoad, cb);
        }
    }

    private void reloadAllWithSyncLoader(CacheOperationCompletionListener listener, Set<K> keysToLoad) {
        OperationCompletion<K> completion = new OperationCompletion<K>(keysToLoad, listener);
        for (K key : keysToLoad) {
            this.heapCache.executeLoader(completion, key, () -> {
                EntryAction action = this.createEntryAction(key, null, this.ops.unconditionalLoad);
                action.start();
                return this.extractException(action);
            });
        }
    }

    private Throwable extractException(EntryAction<K, V, ?> action) {
        if (action.exceptionToPropagate != null) {
            return action.exceptionToPropagate;
        }
        if (action.result instanceof ExceptionWrapper) {
            return ((ExceptionWrapper)action.result).getException();
        }
        return null;
    }

    private <R> void executeAsyncLoadOrRefresh(K key, Entry<K, V> e, Semantic<K, V, R> op, EntryAction.CompletedCallback<K, V, R> cb) {
        MyEntryAction<R> action = new MyEntryAction<R>(op, key, e, cb);
        action.start();
    }

    protected <R> MyEntryAction<R> createFireAndForgetAction(Entry<K, V> e, Semantic<K, V, R> op) {
        return new MyEntryAction<R>(op, e.getKey(), e, EntryAction.NOOP_CALLBACK);
    }

    @Override
    public Executor getExecutor() {
        return this.heapCache.getExecutor();
    }

    private void checkLoaderPresent() {
        if (!this.isLoaderPresent()) {
            throw new UnsupportedOperationException("loader not set");
        }
    }

    @Override
    public boolean isWeigherPresent() {
        return this.heapCache.eviction.isWeigherPresent();
    }

    @Override
    public boolean isLoaderPresent() {
        return this.loader != null || this.asyncLoader != null;
    }

    V returnValue(V v) {
        return this.heapCache.returnValue(v);
    }

    V returnValue(Entry<K, V> e) {
        return (V)this.returnValue(e.getValueOrException());
    }

    Entry<K, V> lookupQuick(K key) {
        return this.heapCache.lookupEntry(key);
    }

    public V get(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData(this.getClock())) {
            return this.returnValue(e);
        }
        return this.returnValue(this.execute(key, e, this.ops.get(key)));
    }

    public Map<K, V> getAll(Iterable<? extends K> keys) {
        HashMap<K, CacheEntry> map = new HashMap<K, CacheEntry>();
        for (K k : keys) {
            CacheEntry e = this.execute(k, this.ops.getEntry(k));
            if (e == null) continue;
            map.put(k, e);
        }
        return this.heapCache.convertCacheEntry2ValueMap(map);
    }

    public CacheEntry<K, V> getEntry(K key) {
        return this.execute(key, this.ops.getEntry(key));
    }

    @Override
    public int getTotalEntryCount() {
        return this.heapCache.getTotalEntryCount();
    }

    public <R> R invoke(K key, EntryProcessor<K, V, R> processor) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.execute(key, this.ops.invoke(key, processor));
    }

    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        final HeapCache.IteratorFilterEntry2Entry<K, V> it = new HeapCache.IteratorFilterEntry2Entry<K, V>(this.heapCache, this.heapCache.iterateAllHeapEntries(), true);
        Iterator adapted = new Iterator<CacheEntry<K, V>>(){
            CacheEntry<K, V> entry;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public CacheEntry<K, V> next() {
                this.entry = (CacheEntry)it.next();
                return this.entry;
            }

            @Override
            public void remove() {
                if (this.entry == null) {
                    throw new IllegalStateException("call next first");
                }
                WiredCache.this.remove(this.entry.getKey());
            }
        };
        return adapted;
    }

    public V peek(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData(this.getClock())) {
            return this.returnValue(e);
        }
        return this.returnValue(this.execute(key, this.ops.peek(key)));
    }

    public Map<K, V> peekAll(Iterable<? extends K> keys) {
        HashMap<K, CacheEntry> map = new HashMap<K, CacheEntry>();
        for (K k : keys) {
            CacheEntry e = this.execute(k, this.ops.peekEntry(k));
            if (e == null) continue;
            map.put(k, e);
        }
        return this.heapCache.convertCacheEntry2ValueMap(map);
    }

    @Override
    public InternalCacheInfo getLatestInfo() {
        return this.heapCache.getLatestInfo(this);
    }

    @Override
    public InternalCacheInfo getInfo() {
        return this.heapCache.getInfo(this);
    }

    @Override
    public CommonMetrics getCommonMetrics() {
        return this.heapCache.getCommonMetrics();
    }

    @Override
    public void logAndCountInternalException(String s, Throwable t) {
        this.heapCache.logAndCountInternalException(s, t);
    }

    @Override
    public void checkIntegrity() {
        this.heapCache.checkIntegrity();
    }

    public boolean isClosed() {
        return this.heapCache.isClosed();
    }

    public void init() {
        this.heapCache.timing.setTarget(this);
        this.heapCache.initWithoutTimerHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTimerJobs() {
        Object object = this.lockObject();
        synchronized (object) {
            this.heapCache.cancelTimerJobs();
        }
    }

    public void clear() {
        this.heapCache.clear();
    }

    public void close() {
        try {
            this.heapCache.closePart1();
        }
        catch (CacheClosedException ex) {
            return;
        }
        Object waitForStorage = null;
        this.heapCache.closePart2(this);
        this.closeCustomization(this.writer, "writer");
        if (this.syncEntryCreatedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryCreatedListeners) {
                this.closeCustomization(cacheEntryCreatedListener, "entryCreatedListener");
            }
        }
        if (this.syncEntryUpdatedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryUpdatedListeners) {
                this.closeCustomization(cacheEntryCreatedListener, "entryUpdatedListener");
            }
        }
        if (this.syncEntryRemovedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryRemovedListeners) {
                this.closeCustomization(cacheEntryCreatedListener, "entryRemovedListener");
            }
        }
        if (this.syncEntryExpiredListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryExpiredListeners) {
                this.closeCustomization(cacheEntryCreatedListener, "entryExpiredListener");
            }
        }
    }

    @Override
    public CacheEntry<K, V> returnCacheEntry(ExaminationEntry<K, V> e) {
        return this.heapCache.returnCacheEntry(e);
    }

    private Object lockObject() {
        return this.heapCache.lock;
    }

    @Override
    public Eviction getEviction() {
        return this.heapCache.getEviction();
    }

    @Override
    public void onEvictionFromHeap(Entry<K, V> e) {
        CacheEntry<K, V> currentEntry = this.heapCache.returnCacheEntry(e);
        if (this.syncEntryEvictedListeners != null) {
            for (CacheEntryEvictedListener<K, V> l : this.syncEntryEvictedListeners) {
                try {
                    l.onEntryEvicted(this.getUserCache(), currentEntry);
                }
                catch (Throwable t) {
                    this.getLog().warn("Exception from eviction listener", t);
                }
            }
        }
    }

    @Override
    protected <R> EntryAction<K, V, R> createEntryAction(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        return new MyEntryAction<R>(op, key, e);
    }

    @Override
    public String getEntryState(K key) {
        return this.heapCache.getEntryState(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventExpireEntry(Entry<K, V> e, Object task) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
            long nrt = e.getNextRefreshTime();
            long now = this.heapCache.clock.millis();
            if (now < Math.abs(nrt)) {
                if (nrt > 0L) {
                    this.heapCache.timing.scheduleFinalTimerForSharpExpiry(e);
                    e.setNextRefreshTime(-nrt);
                }
                return;
            }
        }
        this.enqueueTimerAction(e, this.ops.expireEvent);
    }

    private <R> void enqueueTimerAction(Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction action = this.createFireAndForgetAction((Entry)e, (Semantic)op);
        this.getExecutor().execute(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventRefresh(Entry<K, V> e, Object task) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
            if (this.asyncLoader != null) {
                this.enqueueTimerAction(e, this.ops.refresh);
                return;
            }
            try {
                this.heapCache.refreshExecutor.execute(this.createFireAndForgetAction((Entry)e, this.ops.refresh));
            }
            catch (RejectedExecutionException ex) {
                this.metrics().refreshRejected();
                this.enqueueTimerAction(e, this.ops.expireEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventProbationTerminated(Entry<K, V> e, Object task) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
        }
        this.enqueueTimerAction(e, this.ops.expireEvent);
    }

    @Override
    public Cache<K, V> getUserCache() {
        return this.userCache;
    }

    class MyEntryAction<R>
    extends EntryAction<K, V, R> {
        MyEntryAction(Semantic<K, V, R> op, K k, Entry<K, V> e) {
            super(WiredCache.this.heapCache, WiredCache.this, op, k, e);
        }

        MyEntryAction(Semantic<K, V, R> op, K k, Entry<K, V> e, EntryAction.CompletedCallback cb) {
            super(WiredCache.this.heapCache, WiredCache.this, op, k, e, cb);
        }

        @Override
        protected boolean mightHaveListeners() {
            return true;
        }

        @Override
        protected CacheEntryCreatedListener<K, V>[] entryCreatedListeners() {
            return WiredCache.this.syncEntryCreatedListeners;
        }

        @Override
        protected CacheEntryRemovedListener<K, V>[] entryRemovedListeners() {
            return WiredCache.this.syncEntryRemovedListeners;
        }

        @Override
        protected CacheEntryUpdatedListener<K, V>[] entryUpdatedListeners() {
            return WiredCache.this.syncEntryUpdatedListeners;
        }

        @Override
        protected CacheEntryExpiredListener<K, V>[] entryExpiredListeners() {
            return WiredCache.this.syncEntryExpiredListeners;
        }

        @Override
        protected CacheWriter<K, V> writer() {
            return WiredCache.this.writer;
        }

        @Override
        protected Timing<K, V> timing() {
            return this.heapCache.timing;
        }

        public Executor getLoaderExecutor() {
            return this.heapCache.loaderExecutor;
        }

        @Override
        protected AsyncCacheLoader<K, V> asyncLoader() {
            return WiredCache.this.asyncLoader;
        }

        @Override
        protected Executor executor() {
            return this.heapCache.getExecutor();
        }

        @Override
        public Executor getExecutor() {
            return this.executor();
        }

        @Override
        public ExceptionPropagator getExceptionPropagator() {
            return this.heapCache.exceptionPropagator;
        }
    }
}

