/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Random;
import org.cache2k.CacheEntry;
import org.cache2k.integration.ExceptionInformation;
import org.cache2k.integration.ResiliencePolicy;

public class DefaultResiliencePolicy<K, V>
extends ResiliencePolicy<K, V> {
    static final Random SHARED_RANDOM = new Random();
    static final int RETRY_PERCENT_OF_RESILIENCE_DURATION = 10;
    static final int MIN_RETRY_INTERVAL = 1000;
    private double multiplier = 1.5;
    private double randomization = 0.5;
    private long resilienceDuration;
    private long maxRetryInterval;
    private long retryInterval;

    public DefaultResiliencePolicy() {
    }

    public DefaultResiliencePolicy(double multiplier, double randomization) {
        this.multiplier = multiplier;
        this.randomization = randomization;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public double getRandomization() {
        return this.randomization;
    }

    public void setRandomization(double randomization) {
        this.randomization = randomization;
    }

    public long getResilienceDuration() {
        return this.resilienceDuration;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void init(ResiliencePolicy.Context ctx) {
        this.resilienceDuration = ctx.getResilienceDurationMillis();
        this.maxRetryInterval = ctx.getMaxRetryIntervalMillis();
        this.retryInterval = ctx.getRetryIntervalMillis();
        if (this.resilienceDuration == -1L) {
            this.resilienceDuration = ctx.getExpireAfterWriteMillis() == Long.MAX_VALUE ? 0L : ctx.getExpireAfterWriteMillis();
        } else if (this.maxRetryInterval == -1L) {
            this.maxRetryInterval = this.resilienceDuration;
        }
        if (this.maxRetryInterval == -1L && this.retryInterval == -1L) {
            this.maxRetryInterval = this.resilienceDuration;
        }
        if (this.retryInterval == -1L) {
            this.retryInterval = this.resilienceDuration * 10L / 100L;
            this.retryInterval = Math.min(this.retryInterval, this.maxRetryInterval);
            this.retryInterval = Math.max(1000L, this.retryInterval);
        }
        if (this.retryInterval > this.maxRetryInterval) {
            this.maxRetryInterval = this.retryInterval;
        }
        if (this.maxRetryInterval > this.resilienceDuration && this.resilienceDuration != 0L) {
            this.resilienceDuration = this.maxRetryInterval;
        }
    }

    public long suppressExceptionUntil(K key, ExceptionInformation exceptionInformation, CacheEntry<K, V> cachedContent) {
        if (this.resilienceDuration == 0L) {
            return 0L;
        }
        if (this.resilienceDuration == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long maxSuppressUntil = exceptionInformation.getSinceTime() + this.resilienceDuration;
        long deltaMs = this.calculateRetryDelta(exceptionInformation);
        return Math.min(exceptionInformation.getLoadTime() + deltaMs, maxSuppressUntil);
    }

    private long calculateRetryDelta(ExceptionInformation exceptionInformation) {
        long delta = (long)((double)this.retryInterval * Math.pow(this.multiplier, exceptionInformation.getRetryCount()));
        delta = (long)((double)delta + SHARED_RANDOM.nextDouble() * this.randomization * (double)delta);
        return Math.min(delta, this.maxRetryInterval);
    }

    public long retryLoadAfter(K key, ExceptionInformation exceptionInformation) {
        if (this.retryInterval == 0L) {
            return 0L;
        }
        if (this.retryInterval == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return exceptionInformation.getLoadTime() + this.calculateRetryDelta(exceptionInformation);
    }
}

